/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.recipe.SpawnEggShapelessRecipe;

import jp.artan.dmlreloaded.common.mobmetas.MobMetaData;
import jp.artan.dmlreloaded.init.DMLRecipeSerializer;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import jp.artan.dmlreloaded.util.DataModelHelper;
import jp.artan.dmlreloaded.util.TierHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpawnEggShapelessRecipe
extends CustomRecipe {
    public SpawnEggShapelessRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        MobMetaData metaData = this.getMobMetaData(inventory);
        ItemPristineMatter pristineMatter = this.getPristineMatter(inventory);
        boolean flag = metaData != null && pristineMatter != null && pristineMatter == metaData.getPristineMatter();
        boolean egg = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack1 = inventory.m_8020_(i);
            if (itemstack1.m_41720_() != Items.f_42521_) continue;
            egg = true;
        }
        return flag && egg;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        MobMetaData metaData = this.getMobMetaData(pContainer);
        if (metaData == null) {
            return ItemStack.f_41583_;
        }
        return metaData.getSpawnEgg();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList list = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack1 = inventory.m_8020_(i);
            if (!(itemstack1.m_41720_() instanceof ItemDataModel)) continue;
            list.set(i, (Object)itemstack1.m_41777_());
        }
        return list;
    }

    @Nullable
    private MobMetaData getMobMetaData(CraftingContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int tier;
            ItemStack dataModel = inventory.m_8020_(i);
            if (!(dataModel.m_41720_() instanceof ItemDataModel) || !TierHelper.isMaxTier(tier = DataModelHelper.getTier(dataModel))) continue;
            return DataModelHelper.getMobMetaData(dataModel);
        }
        return null;
    }

    @Nullable
    private ItemPristineMatter getPristineMatter(CraftingContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            Item item = itemstack.m_41720_();
            if (!(item instanceof ItemPristineMatter)) continue;
            ItemPristineMatter pristineMatter = (ItemPristineMatter)item;
            return pristineMatter;
        }
        return null;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DMLRecipeSerializer.CRAFTING_SPECIAL_SPAWN_EGG_RECIPE.get();
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<SpawnEggShapelessRecipe> {
        public Serializer() {
            super(SpawnEggShapelessRecipe::new);
        }
    }
}

