/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.recipe.DataModelUpgradeRecipe;

import jp.artan.dmlreloaded.init.DMLRecipeSerializer;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemDataModelUpgrade;
import jp.artan.dmlreloaded.util.DataModelHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DataModelUpgradeRecipe
extends CustomRecipe {
    public DataModelUpgradeRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean isNotNullable;
        ItemStack metaData = this.getMobMetaData(container);
        ItemDataModelUpgrade dataModelUpgrade = this.getDataModelUpgrade(container);
        boolean bl = isNotNullable = metaData != null && dataModelUpgrade != null;
        if (isNotNullable) {
            int currentTier = DataModelHelper.getTier(metaData);
            int nextTier = dataModelUpgrade.getNextTier();
            return this.isContainerItems(container, 2) && currentTier < nextTier;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess pRegistryAccess) {
        ItemStack metaDataItem = this.getMobMetaData(container).m_41777_();
        metaDataItem.m_41764_(1);
        ItemDataModelUpgrade dataModelUpgrade = this.getDataModelUpgrade(container);
        DataModelHelper.setTier(metaDataItem, dataModelUpgrade.getNextTier());
        return metaDataItem;
    }

    private boolean isContainerItems(CraftingContainer inventory, int size) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack dataModel = inventory.m_8020_(i);
            count += dataModel.m_41619_() ? 0 : 1;
        }
        return count == size;
    }

    @Nullable
    private ItemStack getMobMetaData(CraftingContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack dataModel = inventory.m_8020_(i);
            if (!(dataModel.m_41720_() instanceof ItemDataModel)) continue;
            return dataModel;
        }
        return null;
    }

    @Nullable
    private ItemDataModelUpgrade getDataModelUpgrade(CraftingContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            Item item = itemstack.m_41720_();
            if (!(item instanceof ItemDataModelUpgrade)) continue;
            ItemDataModelUpgrade dataModelUpgrade = (ItemDataModelUpgrade)item;
            return dataModelUpgrade;
        }
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DMLRecipeSerializer.CRAFTING_SPECIAL_DATA_MODE_UPGRADE_RECIPE.get();
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<DataModelUpgradeRecipe> {
        public Serializer() {
            super(DataModelUpgradeRecipe::new);
        }
    }
}

