/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.init;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import jp.artan.artansprojectcoremod.sets.ArmorItems;
import jp.artan.artansprojectcoremod.utils.inject.NonNullFunction;
import jp.artan.dmlreloaded.common.LivingMatterType;
import jp.artan.dmlreloaded.common.MobKey;
import jp.artan.dmlreloaded.init.DMLCreativeTab;
import jp.artan.dmlreloaded.item.DMLSmithingTemplateItem;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemDataModelUpgrade;
import jp.artan.dmlreloaded.item.ItemGlitchArmor;
import jp.artan.dmlreloaded.item.ItemGlitchHeart;
import jp.artan.dmlreloaded.item.ItemGlitchIngot;
import jp.artan.dmlreloaded.item.ItemLivingMatter;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import jp.artan.dmlreloaded.item.ItemSootedRedstone;
import jp.artan.dmlreloaded.item.material.GlitchArmorMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class DMLItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"dmlreloaded", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<ItemSootedRedstone> SOOT_COVERED_REDSTONE = DMLItems.register("soot_covered_redstone", ItemSootedRedstone::new);
    public static final RegistrySupplier<Item> SOOT_COVERED_PLATE = DMLItems.register("soot_covered_plate", Item::new);
    public static final RegistrySupplier<ItemGlitchHeart> GLITCH_HEART = DMLItems.register("glitch_heart", ItemGlitchHeart::new);
    public static final RegistrySupplier<ItemGlitchIngot> GLITCH_INGOT = DMLItems.register("glitch_infused_ingot", ItemGlitchIngot::new);
    public static final RegistrySupplier<Item> NETHERITE_GLITCH_INGOT = DMLItems.register("netherite_glitch_infused_ingot", p -> new Item(p.m_41486_()));
    public static final RegistrySupplier<Item> POLYMER_CLAY = DMLItems.register("polymer_clay", Item::new);
    public static final RegistrySupplier<DMLSmithingTemplateItem> GLITCH_UPGRADE_SMITHING_TEMPLATE = DMLItems.register("glitch_upgrade_smithing_template", p -> DMLSmithingTemplateItem.createGlitchUpgradeTemplate());
    public static final ArmorItems<ItemGlitchArmor> GLITCH_ARMOR = DMLItems.registerGlitchArmor();
    public static final ArmorItems<ItemGlitchArmor> NETHERITE_GLITCH_ARMOR = DMLItems.registerNetheriteGlitchArmor();
    public static final RegistrySupplier<ItemDataModelUpgrade> DATA_MODEL_UPGRADE_TIER1 = DMLItems.register("data_model_upgrade_tier1", p -> new ItemDataModelUpgrade((Item.Properties)p, 1));
    public static final RegistrySupplier<ItemDataModelUpgrade> DATA_MODEL_UPGRADE_TIER2 = DMLItems.register("data_model_upgrade_tier2", p -> new ItemDataModelUpgrade((Item.Properties)p, 2));
    public static final RegistrySupplier<ItemDataModelUpgrade> DATA_MODEL_UPGRADE_TIER3 = DMLItems.register("data_model_upgrade_tier3", p -> new ItemDataModelUpgrade((Item.Properties)p, 3));
    public static final RegistrySupplier<ItemDataModelUpgrade> DATA_MODEL_UPGRADE_TIER4 = DMLItems.register("data_model_upgrade_tier4", p -> new ItemDataModelUpgrade((Item.Properties)p, 4));
    public static final RegistrySupplier<Item> DATA_MODEL_BLANK = DMLItems.register("data_model_blank", Item::new);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_BLAZE = DMLItems.registerDataModel("data_model_blaze", MobKey.BLAZE);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_CREEPER = DMLItems.registerDataModel("data_model_creeper", MobKey.CREEPER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_ENDER_DRAGON = DMLItems.registerDataModel("data_model_ender_dragon", MobKey.ENDER_DRAGON);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_ELDER_GUARDIAN = DMLItems.registerDataModel("data_model_elder_guardian", MobKey.ELDER_GUARDIAN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_ENDERMAN = DMLItems.registerDataModel("data_model_enderman", MobKey.ENDERMAN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_EVOKER = DMLItems.registerDataModel("data_model_evoker", MobKey.EVOKER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_GHAST = DMLItems.registerDataModel("data_model_ghast", MobKey.GHAST);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_GUARDIAN = DMLItems.registerDataModel("data_model_guardian", MobKey.GUARDIAN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_HOGLIN = DMLItems.registerDataModel("data_model_hoglin", MobKey.HOGLIN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_MAGMA_CUBE = DMLItems.registerDataModel("data_model_magma_cube", MobKey.MAGMA_CUBE);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_PHANTOM = DMLItems.registerDataModel("data_model_phantom", MobKey.PHANTOM);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_PIGLIN = DMLItems.registerDataModel("data_model_piglin", MobKey.PIGLIN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_RAVAGER = DMLItems.registerDataModel("data_model_ravager", MobKey.RAVAGER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_SHULKER = DMLItems.registerDataModel("data_model_shulker", MobKey.SHULKER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_SKELETON = DMLItems.registerDataModel("data_model_skeleton", MobKey.SKELETON);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_SLIME = DMLItems.registerDataModel("data_model_slime", MobKey.SLIME);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_SPIDER = DMLItems.registerDataModel("data_model_spider", MobKey.SPIDER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_WARDEN = DMLItems.registerDataModel("data_model_warden", MobKey.WARDEN);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_WITCH = DMLItems.registerDataModel("data_model_witch", MobKey.WITCH);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_WITHER_SKELETON = DMLItems.registerDataModel("data_model_wither_skeleton", MobKey.WITHER_SKELETON);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_WITHER = DMLItems.registerDataModel("data_model_wither", MobKey.WITHER);
    public static final RegistrySupplier<ItemDataModel> DATA_MODEL_ZOMBIE = DMLItems.registerDataModel("data_model_zombie", MobKey.ZOMBIE);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_BLAZE = DMLItems.registerPristineMatter("pristine_matter_blaze", MobKey.BLAZE);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_CREEPER = DMLItems.registerPristineMatter("pristine_matter_creeper", MobKey.CREEPER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_ENDER_DRAGON = DMLItems.registerPristineMatter("pristine_matter_ender_dragon", MobKey.ENDER_DRAGON);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_ELDER_GUARDIAN = DMLItems.registerPristineMatter("pristine_matter_elder_guardian", MobKey.ELDER_GUARDIAN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_ENDERMAN = DMLItems.registerPristineMatter("pristine_matter_enderman", MobKey.ENDERMAN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_EVOKER = DMLItems.registerPristineMatter("pristine_matter_evoker", MobKey.EVOKER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_GHAST = DMLItems.registerPristineMatter("pristine_matter_ghast", MobKey.GHAST);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_GUARDIAN = DMLItems.registerPristineMatter("pristine_matter_guardian", MobKey.GUARDIAN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_HOGLIN = DMLItems.registerPristineMatter("pristine_matter_hoglin", MobKey.HOGLIN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_MAGMA_CUBE = DMLItems.registerPristineMatter("pristine_matter_magma_cube", MobKey.MAGMA_CUBE);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_PHANTOM = DMLItems.registerPristineMatter("pristine_matter_phantom", MobKey.PHANTOM);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_PIGLIN = DMLItems.registerPristineMatter("pristine_matter_piglin", MobKey.PIGLIN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_RAVAGER = DMLItems.registerPristineMatter("pristine_matter_ravager", MobKey.RAVAGER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_SHULKER = DMLItems.registerPristineMatter("pristine_matter_shulker", MobKey.SHULKER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_SKELETON = DMLItems.registerPristineMatter("pristine_matter_skeleton", MobKey.SKELETON);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_SLIME = DMLItems.registerPristineMatter("pristine_matter_slime", MobKey.SLIME);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_SPIDER = DMLItems.registerPristineMatter("pristine_matter_spider", MobKey.SPIDER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_WARDEN = DMLItems.registerPristineMatter("pristine_matter_warden", MobKey.WARDEN);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_WITCH = DMLItems.registerPristineMatter("pristine_matter_witch", MobKey.WITCH);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_WITHER_SKELETON = DMLItems.registerPristineMatter("pristine_matter_wither_skeleton", MobKey.WITHER_SKELETON);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_WITHER = DMLItems.registerPristineMatter("pristine_matter_wither", MobKey.WITHER);
    public static final RegistrySupplier<ItemPristineMatter> PRISTINE_MATTER_ZOMBIE = DMLItems.registerPristineMatter("pristine_matter_zombie", MobKey.ZOMBIE);
    public static final RegistrySupplier<ItemLivingMatter> LIVING_MATTER_EXTRATERRESTRIAL = DMLItems.registerLivingMatter("living_matter_extraterrestrial", LivingMatterType.EXTRATERRESTRIAL);
    public static final RegistrySupplier<ItemLivingMatter> LIVING_MATTER_HELLISH = DMLItems.registerLivingMatter("living_matter_hellish", LivingMatterType.HELLISH);
    public static final RegistrySupplier<ItemLivingMatter> LIVING_MATTER_OVERWORLDIAN = DMLItems.registerLivingMatter("living_matter_overworldian", LivingMatterType.OVERWORLDIAN);

    public static void register() {
        ITEMS.register();
    }

    private static ArmorItems<ItemGlitchArmor> registerGlitchArmor() {
        RegistrySupplier helmet = DMLItems.register("glitch_infused_helmet", p -> new ItemGlitchArmor(GlitchArmorMaterials.GLITCH, ArmorItem.Type.HELMET, (Item.Properties)p));
        RegistrySupplier chestplate = DMLItems.register("glitch_infused_chestplate", p -> new ItemGlitchArmor(GlitchArmorMaterials.GLITCH, ArmorItem.Type.CHESTPLATE, (Item.Properties)p));
        RegistrySupplier leggings = DMLItems.register("glitch_infused_leggings", p -> new ItemGlitchArmor(GlitchArmorMaterials.GLITCH, ArmorItem.Type.LEGGINGS, (Item.Properties)p));
        RegistrySupplier boots = DMLItems.register("glitch_infused_boots", p -> new ItemGlitchArmor(GlitchArmorMaterials.GLITCH, ArmorItem.Type.BOOTS, (Item.Properties)p));
        return new ArmorItems(helmet, chestplate, leggings, boots);
    }

    private static ArmorItems<ItemGlitchArmor> registerNetheriteGlitchArmor() {
        RegistrySupplier helmet = DMLItems.register("netherite_glitch_infused_helmet", p -> new ItemGlitchArmor(GlitchArmorMaterials.NETHERITE_GLITCH, ArmorItem.Type.HELMET, p.m_41486_()));
        RegistrySupplier chestplate = DMLItems.register("netherite_glitch_infused_chestplate", p -> new ItemGlitchArmor(GlitchArmorMaterials.NETHERITE_GLITCH, ArmorItem.Type.CHESTPLATE, p.m_41486_()));
        RegistrySupplier leggings = DMLItems.register("netherite_glitch_infused_leggings", p -> new ItemGlitchArmor(GlitchArmorMaterials.NETHERITE_GLITCH, ArmorItem.Type.LEGGINGS, p.m_41486_()));
        RegistrySupplier boots = DMLItems.register("netherite_glitch_infused_boots", p -> new ItemGlitchArmor(GlitchArmorMaterials.NETHERITE_GLITCH, ArmorItem.Type.BOOTS, p.m_41486_()));
        return new ArmorItems(helmet, chestplate, leggings, boots);
    }

    private static RegistrySupplier<ItemDataModel> registerDataModel(String name, MobKey mobKey) {
        return DMLItems.register(name, p -> new ItemDataModel((Item.Properties)p, mobKey));
    }

    private static RegistrySupplier<ItemPristineMatter> registerPristineMatter(String name, MobKey mobKey) {
        return DMLItems.register(name, p -> new ItemPristineMatter((Item.Properties)p, mobKey));
    }

    private static RegistrySupplier<ItemLivingMatter> registerLivingMatter(String name, LivingMatterType livingMatterType) {
        return DMLItems.register(name, p -> new ItemLivingMatter((Item.Properties)p, livingMatterType));
    }

    private static <T extends Item> RegistrySupplier<T> register(String name, NonNullFunction<Item.Properties, T> item) {
        RegistrySupplier itemRegister = ITEMS.register(name, () -> {
            Item itemInstance = (Item)item.apply((Object)new Item.Properties());
            CreativeTabRegistry.append(DMLCreativeTab.DEEP_MOB_LEARNING_RELOADED, (ItemLike[])new ItemLike[]{itemInstance});
            return itemInstance;
        });
        return itemRegister;
    }
}

