/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.util;

import jp.artan.dmlreloaded.config.ClientConfig;
import jp.artan.dmlreloaded.forge.item.ItemDeepLearner;
import jp.artan.dmlreloaded.forge.plugin.PluginInit;
import jp.artan.dmlreloaded.forge.plugin.curios.CuriosUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerHelper {
    private boolean isHoldingDeepLearner;
    private Player player;
    private ItemStack stack;

    public PlayerHelper(Player player) {
        this.player = player;
        ItemStack mainHandStack = this.player.m_21205_();
        ItemStack offHandStack = this.player.m_21206_();
        if (mainHandStack.m_41720_() instanceof ItemDeepLearner) {
            this.stack = mainHandStack;
            this.isHoldingDeepLearner = true;
        } else if (offHandStack.m_41720_() instanceof ItemDeepLearner) {
            this.stack = offHandStack;
            this.isHoldingDeepLearner = true;
        } else if (PluginInit.CURIOS_ACTIVE) {
            ItemStack curiosSlotItem = CuriosUtil.getDeepLearnerCurioItemStack(this.player);
            if (curiosSlotItem.m_41619_()) {
                this.isHoldingDeepLearner = false;
                this.stack = ItemStack.f_41583_;
            } else if (((Boolean)ClientConfig.curiosIntegrationDefaultOverlay.get()).booleanValue() || Screen.m_96637_()) {
                this.stack = curiosSlotItem;
                this.isHoldingDeepLearner = true;
            }
        } else {
            this.isHoldingDeepLearner = false;
            this.stack = ItemStack.f_41583_;
        }
    }

    public boolean isHoldingDeepLearner() {
        return this.isHoldingDeepLearner;
    }

    public ItemStack getHeldDeepLearner() {
        return this.stack;
    }
}

