/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import jp.artan.dmlreloaded.common.mobmetas.MobMetaData;
import jp.artan.dmlreloaded.forge.container.SimulationChamberContainer;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.util.Animation;
import jp.artan.dmlreloaded.util.DataModelHelper;
import jp.artan.dmlreloaded.util.MathHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SimulationChamberScreen
extends AbstractContainerScreen<SimulationChamberContainer> {
    private HashMap<String, Animation> animationList;
    private HashMap<String, String> simulationText = new HashMap();
    private Level level;
    private ItemStack currentDataModel = ItemStack.f_41583_;
    private static final ResourceLocation base = new ResourceLocation("dmlreloaded", "textures/gui/simulation_chamber_base.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("dmlreloaded", "textures/gui/default_gui.png");

    public SimulationChamberScreen(SimulationChamberContainer container, Inventory playerInv, Component component) {
        super((AbstractContainerMenu)container, playerInv, component);
        this.animationList = new HashMap();
        this.level = playerInv.f_35978_.m_9236_();
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int topStart = top - 39;
        int spacing = 12;
        MobMetaData data = DataModelHelper.getMobMetaData(((SimulationChamberContainer)this.m_6262_()).getDataModel());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)base);
        pGuiGraphics.m_280218_(base, left - 20, top - 36, 0, 0, 216, 141);
        pGuiGraphics.m_280218_(base, left - 41, top - 36, 0, 141, 18, 18);
        int energyStored1 = ((SimulationChamberContainer)this.f_97732_).data.m_6413_(2) & 0xFFFF;
        int energyStored2 = (((SimulationChamberContainer)this.f_97732_).data.m_6413_(3) & 0xFFFF) << 16 & 0xFFFF0000;
        int energyStored = energyStored1 | energyStored2;
        int maxEnergy1 = ((SimulationChamberContainer)this.f_97732_).data.m_6413_(4) & 0xFFFF;
        int maxEnergy2 = (((SimulationChamberContainer)this.f_97732_).data.m_6413_(5) & 0xFFFF) << 16 & 0xFFFF0000;
        int maxEnergy = maxEnergy1 | maxEnergy2;
        int energyBarHeight = MathHelper.ensureRange((int)((float)energyStored / (float)(maxEnergy - data.getSimulationTickCost()) * 87.0f), 0, 87);
        int energyBarOffset = 87 - energyBarHeight;
        pGuiGraphics.m_280218_(base, left + 183, top + 12 + energyBarOffset, 25, 141, 7, energyBarHeight);
        if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) != 4) {
            int dataBarHeight = MathHelper.ensureRange((int)((float)DataModelHelper.getCurrentTierSimulationCountWithKills(((SimulationChamberContainer)this.m_6262_()).getDataModel()) / (float)DataModelHelper.getTierRoof(((SimulationChamberContainer)this.m_6262_()).getDataModel()) * 87.0f), 0, 87);
            int dataBarOffset = 87 - dataBarHeight;
            pGuiGraphics.m_280218_(base, left - 14, top + 12 + dataBarOffset, 18, 141, 7, dataBarHeight);
        } else {
            pGuiGraphics.m_280218_(base, left - 14, top + 12, 18, 141, 7, 87);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)defaultGui);
        pGuiGraphics.m_280218_(defaultGui, left + 0, top + 111, 0, 0, 176, 90);
        if (this.dataModelChanged()) {
            this.resetAnimations();
        }
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        int x = pMouseX - this.getGuiLeft();
        int y = pMouseY - this.getGuiTop();
        if (11 <= y && y < 100) {
            if (-15 <= x && x < -6) {
                if (!((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_()) {
                    if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) != 4) {
                        tooltip.add(Component.m_237110_((String)"dmlreloaded.gui.simulation_chamber.collected", (Object[])new Object[]{DataModelHelper.getCurrentTierSimulationCountWithKills(((SimulationChamberContainer)this.m_6262_()).getDataModel()), DataModelHelper.getTierRoof(((SimulationChamberContainer)this.m_6262_()).getDataModel())}));
                    } else {
                        tooltip.add(Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.max_tier"));
                    }
                } else {
                    tooltip.add(Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.missing"));
                }
                pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX + 2, pMouseY + 2);
            } else if (182 <= x && x < 191) {
                tooltip.add(Component.m_237110_((String)"dmlreloaded.gui.energy.energystored", (Object[])new Object[]{f.format(energyStored), f.format(maxEnergy)}));
                if (!((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_()) {
                    MobMetaData meta = DataModelHelper.getMobMetaData(((SimulationChamberContainer)this.m_6262_()).getDataModel());
                    tooltip.add(Component.m_237110_((String)"dmlreloaded.gui.simulation_chamber.drain", (Object[])new Object[]{f.format(meta.getSimulationTickCost())}));
                }
                pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX - 90, pMouseY - 16);
            }
        }
        int leftTopConsole = left - 11;
        if (!(((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41720_() instanceof ItemDataModel)) {
            lines = new Component[]{Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.insert"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.to_begin")};
            Animation a1 = this.getAnimation("pleaseInsert1");
            Animation a2 = this.getAnimation("pleaseInsert2");
            this.animateString(pGuiGraphics, lines[0], a1, null, 1, false, leftTopConsole, topStart + spacing, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[1], a2, a1, 1, false, leftTopConsole, topStart + spacing * 2, 0xFFFFFF);
        } else if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) == 0) {
            lines = new Component[]{Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.tier1.1"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.tier1.2"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.tier1.3")};
            Animation insufData = this.getAnimation("insufData1");
            Animation insufData2 = this.getAnimation("insufData2");
            Animation insufData3 = this.getAnimation("insufData3");
            this.animateString(pGuiGraphics, lines[0], insufData, null, 1, false, leftTopConsole, topStart + spacing, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[1], insufData2, insufData, 1, false, leftTopConsole, topStart + spacing * 2, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[2], insufData3, insufData2, 1, false, leftTopConsole, topStart + spacing * 3, 0xFFFFFF);
        } else {
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.tiers.tier", (Object[])new Object[]{DataModelHelper.getTierName(((SimulationChamberContainer)this.m_6262_()).getDataModel(), false)}), leftTopConsole, topStart + spacing, 0xFFFFFF);
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.tiers.tier", (Object[])new Object[]{DataModelHelper.getTierName(((SimulationChamberContainer)this.m_6262_()).getDataModel(), false)}), leftTopConsole, topStart + spacing, 0xFFFFFF);
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.gui.simulation_chamber.iterations", (Object[])new Object[]{f.format(DataModelHelper.getTotalSimulationCount(((SimulationChamberContainer)this.m_6262_()).getDataModel()))}), leftTopConsole, topStart + spacing * 2, 0xFFFFFF);
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.gui.simulation_chamber.pristine_chance", (Object[])new Object[]{DataModelHelper.getPristineChance(((SimulationChamberContainer)this.m_6262_()).getDataModel())}), leftTopConsole, topStart + spacing * 3, 0xFFFFFF);
        }
        this.drawConsoleText(pGuiGraphics, spacing);
    }

    private void drawConsoleText(GuiGraphics pGuiGraphics, int spacing) {
        int leftStart = this.getGuiLeft();
        int topStart = this.getGuiTop() + 14;
        if (((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_() || DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) == 0) {
            this.animateString(pGuiGraphics, (Component)Component.m_237113_((String)"_"), this.getAnimation("blinkingUnderline"), null, 16, true, leftStart, topStart, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).getPolymerClay().m_41619_() && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.cannot_begin"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.missing_polymer"), Component.m_237113_((String)"_")};
            Animation a1 = this.getAnimation("inputSlotEmpty1");
            Animation a2 = this.getAnimation("inputSlotEmpty2");
            Animation a3 = this.getAnimation("blinkingUnderline1");
            this.animateString(pGuiGraphics, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).data.m_6413_(1) < 300 * DataModelHelper.getSimulationTickCost(((SimulationChamberContainer)this.m_6262_()).getDataModel()) && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{Component.m_237113_((String)"Cannot begin simulation"), Component.m_237113_((String)"System energy levels critical"), Component.m_237113_((String)"_")};
            Animation a1 = this.getAnimation("lowEnergy1");
            Animation a2 = this.getAnimation("lowEnergy2");
            Animation a3 = this.getAnimation("blinkingUnderline2");
            this.animateString(pGuiGraphics, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).outputIsFull() || ((SimulationChamberContainer)this.m_6262_()).pristineIsFull() && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{Component.m_237113_((String)"Cannot begin simulation"), Component.m_237113_((String)"Output or pristine buffer is full"), Component.m_237113_((String)"_")};
            Animation a1 = this.getAnimation("outputSlotFilled1");
            Animation a2 = this.getAnimation("outputSlotFilled2");
            Animation a3 = this.getAnimation("blinkingUnderline3");
            this.animateString(pGuiGraphics, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pGuiGraphics, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) > 0) {
            this.updateSimulationText(((SimulationChamberContainer)this.m_6262_()).getDataModel(), ((SimulationChamberContainer)this.f_97732_).data.m_6413_(1));
            pGuiGraphics.m_280488_(this.f_96547_, ((SimulationChamberContainer)this.m_6262_()).data.m_6413_(0) + "%", leftStart + 158, 134, 0x55FFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine1"), leftStart, topStart, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine1Version"), leftStart + 102, topStart, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine2"), leftStart, topStart + spacing, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine3"), leftStart, topStart + spacing * 2, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine4"), leftStart, topStart + spacing * 3, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine5"), leftStart, topStart + spacing * 4, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine6"), leftStart, topStart + spacing * 5, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine6Result"), leftStart + 118, topStart + spacing * 5, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("simulationProgressLine7"), leftStart, topStart + spacing * 6, 0xFFFFFF);
            pGuiGraphics.m_280488_(this.f_96547_, this.getSimulationText("blinkingDots1"), this.getGuiLeft() + 109, topStart + spacing * 6, 0xFFFFFF);
        } else {
            this.animateString(pGuiGraphics, (Component)Component.m_237113_((String)"_"), this.getAnimation("blinkingUnderline"), null, 16, true, leftStart, topStart + 49, 0xFFFFFF);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private void resetAnimations() {
        this.animationList = new HashMap();
    }

    private boolean dataModelChanged() {
        if (ItemStack.m_41728_((ItemStack)this.currentDataModel, (ItemStack)((SimulationChamberContainer)this.m_6262_()).getDataModel())) {
            return false;
        }
        this.currentDataModel = ((SimulationChamberContainer)this.m_6262_()).getDataModel();
        return true;
    }

    private Animation getAnimation(String key) {
        if (this.animationList.containsKey(key)) {
            return this.animationList.get(key);
        }
        this.animationList.put(key, new Animation());
        return this.animationList.get(key);
    }

    private void animateString(GuiGraphics pGuiGraphics, Component string, Animation anim, Animation precedingAnim, int delay, boolean loop, int left, int top, int color) {
        String result;
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                result = anim.animate(string.getString(), delay, this.level.m_46467_(), loop);
                pGuiGraphics.m_280488_(this.f_96547_, result, left, top, color);
            } else {
                return;
            }
        }
        result = anim.animate(string.getString(), delay, this.level.m_46467_(), loop);
        pGuiGraphics.m_280488_(this.f_96547_, result, left, top, color);
    }

    public String getSimulationText(String key) {
        if (this.simulationText.containsKey(key)) {
            return this.simulationText.get(key);
        }
        this.simulationText.put(key, "");
        return this.simulationText.get(key);
    }

    private String animate(Component string, Animation anim, @Nullable Animation precedingAnim, int delayInTicks, boolean loop, Level world) {
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                return anim.animate(string.getString(), delayInTicks, world.m_46467_(), loop);
            }
            return "";
        }
        return anim.animate(string.getString(), delayInTicks, world.m_46467_(), loop);
    }

    private void updateSimulationText(ItemStack stack, int succesInt) {
        boolean byproductSuccess = succesInt == 1;
        Component[] lines = new Component[]{Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.1"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.2"), Component.m_237110_((String)"dmlreloaded.gui.simulation_chamber.console.3", (Object[])new Object[]{DataModelHelper.getTotalSimulationCount(stack) + 1}), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.4"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.5"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.6"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.7"), Component.m_237115_((String)("dmlreloaded.gui.simulation_chamber.console.8_" + (byproductSuccess ? "succeeded" : "failed"))), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.9"), Component.m_237115_((String)"dmlreloaded.gui.simulation_chamber.console.10")};
        Animation aLine1 = this.getAnimation("simulationProgressLine1");
        Animation aLine1Version = this.getAnimation("simulationProgressLine1Version");
        Animation aLine2 = this.getAnimation("simulationProgressLine2");
        Animation aLine3 = this.getAnimation("simulationProgressLine3");
        Animation aLine4 = this.getAnimation("simulationProgressLine4");
        Animation aLine5 = this.getAnimation("simulationProgressLine5");
        Animation aLine6 = this.getAnimation("simulationProgressLine6");
        Animation aLine6Result = this.getAnimation("simulationProgressLine6Result");
        Animation aLine7 = this.getAnimation("simulationProgressLine7");
        Animation aLine8 = this.getAnimation("blinkingDots1");
        this.simulationText.put("simulationProgressLine1", this.animate(lines[0], aLine1, null, 1, false, this.level));
        this.simulationText.put("simulationProgressLine1Version", " " + this.animate(lines[1], aLine1Version, aLine1, 1, false, this.level));
        this.simulationText.put("simulationProgressLine2", this.animate(lines[2], aLine2, aLine1Version, 1, false, this.level));
        this.simulationText.put("simulationProgressLine3", this.animate(lines[3], aLine3, aLine2, 2, false, this.level));
        this.simulationText.put("simulationProgressLine4", this.animate(lines[4], aLine4, aLine3, 1, false, this.level));
        this.simulationText.put("simulationProgressLine5", this.animate(lines[5], aLine5, aLine4, 2, false, this.level));
        this.simulationText.put("simulationProgressLine6", this.animate(lines[6], aLine6, aLine5, 2, false, this.level));
        this.simulationText.put("simulationProgressLine6Result", this.animate(lines[7], aLine6Result, aLine6, 2, false, this.level));
        this.simulationText.put("simulationProgressLine7", this.animate(lines[8], aLine7, aLine6Result, 1, false, this.level));
        this.simulationText.put("blinkingDots1", this.animate(lines[9], aLine8, aLine7, 8, true, this.level));
    }
}

