/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.artan.artansprojectcoremod.utils.inject.NonNullSupplier;
import jp.artan.dmlreloaded.config.EnergyCostConfig;
import jp.artan.dmlreloaded.forge.container.ExtractionChamberContainer;
import jp.artan.dmlreloaded.forge.init.DMLPacketHandler;
import jp.artan.dmlreloaded.forge.network.ServerboundResultingItemPacket;
import jp.artan.dmlreloaded.forge.screen.buttons.SelectButton;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import jp.artan.dmlreloaded.util.MathHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ExtractionChamberScreen
extends AbstractContainerScreen<ExtractionChamberContainer> {
    private static final ResourceLocation base = new ResourceLocation("dmlreloaded", "textures/gui/extraction_chamber_base.png");
    private static final ResourceLocation extras = new ResourceLocation("dmlreloaded", "textures/gui/buttons/button_select.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("dmlreloaded", "textures/gui/default_gui.png");
    boolean elementsAdded = false;
    private int startIndex;
    private NonNullList<SelectButton> buttons = NonNullList.m_122779_();
    private int selectedIndex;
    private boolean tileSelectData;
    private boolean scrolling;
    private float scrollOffs;

    public ExtractionChamberScreen(ExtractionChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.handler.registerUpdateListener(this::containerChanged);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        ArrayList<MutableComponent> tooltip;
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int x = pMouseX - this.getGuiLeft();
        int y = pMouseY - this.getGuiTop();
        this.selectedIndex = ((ExtractionChamberContainer)this.f_97732_).data.m_6413_(1);
        this.tileSelectData = ((ExtractionChamberContainer)this.f_97732_).data.m_6413_(2) == 1;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)base);
        pGuiGraphics.m_280218_(base, left, top, 0, 0, 178, 83);
        int k = (int)(41.0f * this.scrollOffs);
        int o = 0;
        if (12 + k <= y && y < 31 + k && 76 <= x && x < 82 && this.isScrollBarActive()) {
            o = 6;
        }
        pGuiGraphics.m_280218_(base, left + 76, top + 12 + k, 178 + (this.isScrollBarActive() ? 0 : 12) + o, 0, 6, 19);
        int progress = ((ExtractionChamberContainer)this.f_97732_).data.m_6413_(0);
        int energyStored1 = ((ExtractionChamberContainer)this.f_97732_).data.m_6413_(3) & 0xFFFF;
        int energyStored2 = (((ExtractionChamberContainer)this.f_97732_).data.m_6413_(4) & 0xFFFF) << 16 & 0xFFFF0000;
        int energyStored = energyStored1 | energyStored2;
        int maxEnergy1 = ((ExtractionChamberContainer)this.f_97732_).data.m_6413_(5) & 0xFFFF;
        int maxEnergy2 = (((ExtractionChamberContainer)this.f_97732_).data.m_6413_(6) & 0xFFFF) << 16 & 0xFFFF0000;
        int maxEnergy = maxEnergy1 | maxEnergy2;
        int energyBarHeight = MathHelper.ensureRange((int)((float)energyStored / (float)(maxEnergy - (Integer)EnergyCostConfig.efCostExtractionChamber.get()) * 53.0f), 0, 53);
        int energyBarOffset = 53 - energyBarHeight;
        pGuiGraphics.m_280218_(base, left + 6, top + 10 + energyBarOffset, 0, 83, 7, energyBarHeight);
        int craftingBarHeight = (int)((float)progress / 50.0f * 36.0f);
        int craftingBarOffset = 36 - craftingBarHeight;
        pGuiGraphics.m_280218_(base, left + 86, top + 22 + craftingBarOffset, 7, 83, 6, craftingBarHeight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)defaultGui);
        pGuiGraphics.m_280218_(defaultGui, left + 0, top + 111, 0, 0, 176, 90);
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        if (10 <= y && y < 63 && 6 <= x && x < 13) {
            tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237110_((String)"dmlreloaded.gui.energy.energystored", (Object[])new Object[]{f.format(energyStored), f.format(maxEnergy)}));
            tooltip.add(Component.m_237110_((String)"dmlreloaded.gui.extraction_chamber.opcost", (Object[])new Object[]{f.format(EnergyCostConfig.efCostExtractionChamber.get())}));
            pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX + 1, pMouseY - 11);
        }
        if (23 <= y && y < 58 && 84 <= x && x < 90) {
            tooltip = new ArrayList();
            tooltip.add(Component.m_237113_((String)(progress + "/100")));
            pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX - 1, pMouseY - 11);
        }
        if (!this.getPristine().m_41619_()) {
            this.renderLootList(pGuiGraphics);
            if (!this.elementsAdded) {
                this.renderButtons();
                this.elementsAdded = true;
            }
        } else if (this.elementsAdded) {
            this.buttons.forEach(btn -> this.m_169411_((GuiEventListener)btn));
            this.elementsAdded = false;
        }
    }

    private ItemStack getPristine() {
        return ((ExtractionChamberContainer)this.f_97732_).getPristine();
    }

    private void renderButtons() {
        for (int i = this.startIndex; i < this.startIndex + 9 && i < this.getLootFromPristine().size(); ++i) {
            int j = i - this.startIndex;
            int l = j / 3 * 19;
            int k = j % 3 * 19;
            int resultingIndex = i;
            SelectButton btn = this.selectedIndex == resultingIndex && this.tileSelectData ? new SelectButton(this.getGuiLeft() + 16 + k, 8 + this.getGuiTop() + l, 18, 18, 0, 0, 18, 18, true, extras, button -> {
                if (!((SelectButton)button).isSelected()) {
                    DMLPacketHandler.INSTANCE.sendToServer((Object)new ServerboundResultingItemPacket(((ExtractionChamberContainer)this.f_97732_).pos, this.getItemFromList(resultingIndex), resultingIndex, true));
                    this.buttons.forEach(buuton -> buuton.setSelected(false));
                    ((SelectButton)button).selection();
                    this.scrolling = false;
                } else if (((SelectButton)button).isSelected()) {
                    DMLPacketHandler.INSTANCE.sendToServer((Object)new ServerboundResultingItemPacket(((ExtractionChamberContainer)this.f_97732_).pos, ItemStack.f_41583_, resultingIndex, false));
                    ((SelectButton)button).selection();
                }
            }) : new SelectButton(this.getGuiLeft() + 16 + i % 3 * 19, 8 + this.getGuiTop() + l, 18, 18, 0, 0, 18, 18, extras, button -> {
                if (!((SelectButton)button).isSelected()) {
                    DMLPacketHandler.INSTANCE.sendToServer((Object)new ServerboundResultingItemPacket(((ExtractionChamberContainer)this.f_97732_).pos, this.getItemFromList(resultingIndex), resultingIndex, true));
                    this.buttons.forEach(buuton -> buuton.setSelected(false));
                    ((SelectButton)button).selection();
                    this.scrolling = false;
                } else if (((SelectButton)button).isSelected()) {
                    DMLPacketHandler.INSTANCE.sendToServer((Object)new ServerboundResultingItemPacket(((ExtractionChamberContainer)this.f_97732_).pos, ItemStack.f_41583_, resultingIndex, false));
                    ((SelectButton)button).selection();
                    this.scrolling = false;
                }
            });
            this.buttons.add((Object)btn);
            this.m_142416_((GuiEventListener)btn);
        }
    }

    protected int getOffscreenRows() {
        return (this.getLootFromPristine().size() + 2 - 1) / 2 - 1;
    }

    private boolean isScrollBarActive() {
        return !this.getPristine().m_41619_() && this.getLootFromPristine().size() > 9;
    }

    private void renderLootList(GuiGraphics pGuiGraphics) {
        for (int i = this.startIndex; i < this.startIndex + 9 && i < this.getLootFromPristine().size(); ++i) {
            int j = i - this.startIndex;
            int l = j / 3 * 19;
            int k = j % 3 * 19;
            ItemStack itemStack = this.getItemFromList(i);
            this.renderItemStackWithCount(pGuiGraphics, itemStack, 17 + this.getGuiLeft() + k, 8 + this.getGuiTop() + l, itemStack.m_41613_());
        }
    }

    private ItemStack getItemFromList(int index) {
        if (index >= 0 && index < this.getLootFromPristine().size()) {
            return (ItemStack)this.getLootFromPristine().get(index);
        }
        return ItemStack.f_41583_;
    }

    private NonNullList<ItemStack> getLootFromPristine() {
        ItemStack stack = this.getPristine();
        Item item = stack.m_41720_();
        if (item instanceof ItemPristineMatter) {
            ItemPristineMatter pristine = (ItemPristineMatter)item;
            NonNullList result = NonNullList.m_122779_();
            List<NonNullSupplier<ItemStack>> loots = pristine.getMobKey().getLoot();
            for (int i = 0; i < loots.size(); ++i) {
                result.add((Object)((ItemStack)loots.get(i).get()));
            }
            return result;
        }
        return NonNullList.m_122779_();
    }

    private void renderItemStackWithCount(GuiGraphics pGuiGraphics, ItemStack stack, int x, int y, int count) {
        pGuiGraphics.m_280480_(stack, x, y);
        pGuiGraphics.m_280302_(this.f_96547_, stack, x - 1, y - 1, (String)(count != 1 ? "" + count : ""));
    }

    private void containerChanged() {
        if (this.getPristine().m_41619_()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int k = (int)(41.0f * this.scrollOffs);
        double x = pMouseX - (double)this.getGuiLeft();
        double y = pMouseY - (double)this.getGuiTop();
        if ((double)(12 + k) <= y && y < (double)(31 + k) && 76.0 <= x && x < 82.0) {
            this.scrolling = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 3;
            this.buttons.forEach(btn -> this.m_169411_((GuiEventListener)btn));
            this.elementsAdded = false;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 3;
            this.buttons.forEach(btn -> this.m_169411_((GuiEventListener)btn));
            this.elementsAdded = false;
        }
        return true;
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }
}

