/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import jp.artan.dmlreloaded.common.mobmetas.MobMetaData;
import jp.artan.dmlreloaded.forge.container.DeepLearnerContainer;
import jp.artan.dmlreloaded.forge.item.ItemDeepLearner;
import jp.artan.dmlreloaded.util.DataModelHelper;
import jp.artan.dmlreloaded.util.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DeepLearnerScreen
extends AbstractContainerScreen<DeepLearnerContainer> {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    protected ItemStack deepLearner;
    private InteractionHand hand;
    private MobMetaData meta;
    private Level world;
    private NonNullList<ItemStack> validDataModels;
    private int currentItem = 0;
    private PoseStack pose;
    private ImageButton imgBtnPrev;
    private ImageButton imgBtnNext;
    private static final ResourceLocation base = new ResourceLocation("dmlreloaded", "textures/gui/deeplearner_base.png");
    private static final ResourceLocation netherite_base = new ResourceLocation("dmlreloaded", "textures/gui/netherite_deeplearner_base.png");
    private static final ResourceLocation extras = new ResourceLocation("dmlreloaded", "textures/gui/deeplearner_extras.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("dmlreloaded", "textures/gui/default_gui.png");

    public DeepLearnerScreen(DeepLearnerContainer container, Inventory playerInv, Component component) {
        super((AbstractContainerMenu)container, playerInv, component);
        this.world = playerInv.f_35978_.m_9236_();
        this.hand = playerInv.f_35978_.m_21205_().m_41720_() instanceof ItemDeepLearner ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.deepLearner = playerInv.f_35978_.m_21120_(this.hand);
    }

    private ResourceLocation getBaseTexture() {
        int loopCount = ((ItemDeepLearner)this.deepLearner.m_41720_()).squareSlotSize;
        return switch (loopCount) {
            case 3 -> netherite_base;
            default -> base;
        };
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.pose = this.pose;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBaseTexture());
        pGuiGraphics.m_280218_(this.getBaseTexture(), left - 41, top - 36, 0, 0, 256, 140);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)defaultGui);
        pGuiGraphics.m_280218_(defaultGui, left + 0, top + 111, 0, 0, 176, 90);
        NonNullList<ItemStack> list = ItemDeepLearner.getContainedItems(this.deepLearner);
        this.validDataModels = DataModelHelper.getValidFromList(list);
        if (this.validDataModels.size() > 1) {
            if (this.f_169369_.size() < 2) {
                this.renderCycleButtons(this.pose, left, top);
            }
        } else {
            this.m_169411_((GuiEventListener)this.imgBtnNext);
            this.m_169411_((GuiEventListener)this.imgBtnPrev);
        }
        if (this.validDataModels.size() >= 1 && this.currentItem <= this.validDataModels.size()) {
            int fixPos = this.validDataModels.size() - 1 - this.currentItem < 0 ? this.validDataModels.size() - 1 : this.validDataModels.size() - 1 - this.currentItem;
            this.meta = DataModelHelper.getMobMetaData((ItemStack)this.validDataModels.get(this.validDataModels.size() >= 1 ? fixPos : this.currentItem));
            this.renderMetaDataText(this.meta, left, top, (ItemStack)this.validDataModels.get(fixPos), pGuiGraphics);
            this.renderMobDisplayBox(pGuiGraphics, left, top);
            DeepLearnerScreen.renderEntityInInventory(pGuiGraphics, this.getGuiLeft() - 85, this.getGuiTop() + 52, this.meta, mouseX, mouseY, this.world);
        } else {
            this.renderDefaultScreen(pGuiGraphics);
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int p_97796_, int p_97797_, float p_97798_) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, p_97796_, p_97797_, p_97798_);
        this.m_280072_(pGuiGraphics, p_97796_, p_97797_);
    }

    private void renderDefaultScreen(GuiGraphics pGuiGraphics) {
        int leftStart = this.getGuiLeft() - 32;
        int top = this.getGuiTop() - 32;
        int spacing = 12;
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.not_found"), leftStart, top + spacing, 0x55FFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.insert"), leftStart, top + spacing * 2, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.collect_data"), leftStart, top + spacing * 3, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.when_placed"), leftStart, top + spacing * 4, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.in_order"), leftStart, top + spacing * 6, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.killing_blow"), leftStart, top + spacing * 7, 0xFFFFFF);
    }

    private void renderMetaDataText(MobMetaData meta, int left, int top, ItemStack stack, GuiGraphics pGuiGraphics) {
        DecimalFormat f = new DecimalFormat("0.#");
        int leftStart = this.getGuiLeft() - 32;
        int topStart = top - 40;
        int spacing = 12;
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.name"), leftStart, topStart + spacing, 0x55FFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.gui.mob_name", (Object[])new Object[]{Component.m_237115_((String)meta.getEntityId())}), leftStart, topStart + spacing * 2, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.information"), leftStart, topStart + spacing * 3, 0xFFFFFF);
        int mobTriviaLine = meta.getMobTriviaLine();
        for (int i = 0; i < mobTriviaLine; ++i) {
            pGuiGraphics.m_280430_(this.f_96547_, (Component)meta.getMobTrivia(i), leftStart, topStart + spacing * 3 + (i + 1) * 12, 0xFFFFFF);
        }
        MutableComponent dataModelTier = DataModelHelper.getTierName(stack, false);
        MutableComponent nextTier = DataModelHelper.getTierName(stack, true);
        int totalKills = DataModelHelper.getTotalKillCount(stack);
        double killsToNextTier = DataModelHelper.getKillsToNextTier(stack);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.tiers.tier", (Object[])new Object[]{dataModelTier}), leftStart, topStart + spacing * 8, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.gui.defeated", (Object[])new Object[]{Component.m_237115_((String)meta.getEntityId()), totalKills}), leftStart, topStart + spacing * 9, 0xFFFFFF);
        if (DataModelHelper.getTier(stack) != 4) {
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"dmlreloaded.tiers.tier_next", (Object[])new Object[]{f.format(killsToNextTier), nextTier}), leftStart, topStart + spacing * 10, 0xFFFFFF);
        } else {
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.max"), leftStart, topStart + spacing * 10, 0xFFFFFF);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBaseTexture());
        pGuiGraphics.m_280218_(this.getBaseTexture(), left + 154, topStart + spacing * 2 - 2, 0, 140, 9, 9);
        pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"dmlreloaded.gui.deep_learner.hp"), left + 154, topStart + spacing, 0x55FFFF);
        int numOfHearts = meta.getNumberOfHearts();
        if (numOfHearts == 0) {
            pGuiGraphics.m_280488_(this.f_96547_, "\ufffdk10\ufffdr", left + 164, topStart + spacing * 2 - 1, 0xFFFFFF);
        } else {
            pGuiGraphics.m_280488_(this.f_96547_, "" + meta.getNumberOfHearts(), left + 164, topStart + spacing * 2 - 1, 0xFFFFFF);
        }
    }

    private void renderCycleButtons(PoseStack pose, int left, int top) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)extras);
        this.imgBtnPrev = new ImageButton(this.getGuiLeft() - 84, this.getGuiTop() + 70, 24, 24, 99, 0, 24, extras, 255, 255, btn -> {
            if (this.validDataModels.size() > 1) {
                this.currentItem = this.nextItemIndex();
            }
        });
        this.imgBtnNext = new ImageButton(this.getGuiLeft() - 110, this.getGuiTop() + 70, 24, 24, 75, 0, 24, extras, 255, 255, btn -> {
            if (this.validDataModels.size() > 1) {
                this.currentItem = this.previousItemIndex();
            }
        });
        this.m_142416_((GuiEventListener)this.imgBtnNext);
        this.m_142416_((GuiEventListener)this.imgBtnPrev);
    }

    private void renderMobDisplayBox(GuiGraphics pGuiGraphics, int left, int top) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)extras);
        pGuiGraphics.m_280218_(extras, left - 123, top - 36, 0, 0, 75, 101);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public NonNullList<ItemStack> getItemStacks() {
        NonNullList list = NonNullList.m_122779_();
        int numOfSlots = ((DeepLearnerContainer)this.f_97732_).getInternalSlotSize();
        for (int i = 0; i < numOfSlots; ++i) {
            list.add(i, (Object)((DeepLearnerContainer)this.m_6262_()).m_38853_(i).m_7993_());
        }
        return list;
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    protected void m_6597_(Slot slot, int dragType, int index, ClickType clickTypeIn) {
        this.validDataModels = DataModelHelper.getValidFromList(ItemDeepLearner.getContainedItems(this.deepLearner));
        if (this.validDataModels.size() >= 1 && this.currentItem < this.validDataModels.size()) {
            this.meta = DataModelHelper.getMobMetaData((ItemStack)this.validDataModels.get(this.currentItem));
            if (slot != null && slot.m_7993_().m_41619_()) {
                this.nextItemIndex();
            }
        }
        ((DeepLearnerContainer)this.m_6262_()).getDeepInv().m_6596_();
        super.m_6597_(slot, dragType, index, clickTypeIn);
    }

    public static void renderEntityInInventory(GuiGraphics pGuiGraphics, int xPos, int yPos, MobMetaData meta, double mouseX, double mouseY, Level world) {
        LivingEntity entity = meta.getEntity(world);
        if (entity != null) {
            float scale = DeepLearnerScreen.getScale(entity);
            int offsetY = meta.getOffsetY(entity);
            RenderHelper.renderEntity(pGuiGraphics, xPos, yPos - offsetY, scale, 38.0 - mouseX, (double)(70 - offsetY) - mouseY, entity, meta);
        }
    }

    private static float getScale(LivingEntity livingEntity) {
        float height;
        float width = livingEntity.m_20205_();
        if (width <= (height = livingEntity.m_20206_())) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int nextItemIndex() {
        int result = this.currentItem == this.validDataModels.size() - 1 ? 0 : this.currentItem + 1;
        return result;
    }

    private int previousItemIndex() {
        int result = this.currentItem == 0 ? (this.validDataModels.size() > 1 ? this.validDataModels.size() - 1 : 0) : this.currentItem - 1;
        return result;
    }
}

