/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import jp.artan.dmlreloaded.config.ClientConfig;
import jp.artan.dmlreloaded.forge.item.ItemDeepLearner;
import jp.artan.dmlreloaded.forge.util.PlayerHelper;
import jp.artan.dmlreloaded.util.DataModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DataOverlay
extends Screen {
    private Minecraft mc = Minecraft.m_91087_();
    private ItemStack deepLearner;
    private NonNullList<ItemStack> dataModels;
    private PlayerHelper playerH;
    private int componentHeight = 26;
    private int barSpacing = 12;
    private static final ResourceLocation experienceBar = new ResourceLocation("dmlreloaded", "textures/gui/experience_gui.png");

    public DataOverlay(Component pTitle) {
        super(pTitle);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!this.mc.m_91302_()) {
            return;
        }
        this.playerH = new PlayerHelper((Player)this.mc.f_91074_);
        if (!this.playerH.isHoldingDeepLearner()) {
            return;
        }
        this.deepLearner = this.playerH.getHeldDeepLearner();
        this.dataModels = DataModelHelper.getValidFromList(ItemDeepLearner.getContainedItems(this.deepLearner));
        int x = (Integer)ClientConfig.guiOverlayHorizontalSpacing.get();
        int y = (Integer)ClientConfig.guiOverlayVerticalSpacing.get();
        int position = (Integer)ClientConfig.guiOverlaySide.get();
        switch (position) {
            case 0: {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
                break;
            }
            case 1: {
                x += this.getRightCornerX();
                y += 5;
                break;
            }
            case 2: {
                x = x + this.getLeftCornerX() + 18;
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            case 3: {
                x += this.getRightCornerX();
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            default: {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
            }
        }
        for (int i = 0; i < this.dataModels.size(); ++i) {
            ItemStack stack = (ItemStack)this.dataModels.get(i);
            MutableComponent tierName = DataModelHelper.getTierName(stack, false);
            int tier = DataModelHelper.getTier(stack);
            double k = DataModelHelper.getKillsToNextTier(stack);
            double c = DataModelHelper.getCurrentTierKillCountWithSims(stack);
            int roof = DataModelHelper.getTierRoofAsKills(stack);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            this.drawExperienceBar(guiGraphics, x, y, i, (Component)tierName, tier, k, c, roof, stack);
        }
    }

    private void drawExperienceBar(GuiGraphics guiGraphics, int x, int y, int index, Component tierName, int tier, double killsToNextTier, double currenKillCount, int tierRoof, ItemStack stack) {
        DecimalFormat f = new DecimalFormat("0.#");
        this.drawItemStack(guiGraphics, x - 18, y - 2 + this.barSpacing + index * this.componentHeight, stack);
        guiGraphics.m_280430_(this.mc.f_91062_, (Component)Component.m_237110_((String)"dmlreloaded.gui.deep_learner.overlay", (Object[])new Object[]{tierName}), x - 14, y + index * this.componentHeight + 2, 0xFFFFFF);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)experienceBar);
        guiGraphics.m_280218_(experienceBar, x, y + this.barSpacing + index * this.componentHeight, 0, 0, 89, 12);
        if (tier == 4) {
            guiGraphics.m_280218_(experienceBar, x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, 89, 11);
        } else {
            guiGraphics.m_280218_(experienceBar, x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, (int)((float)currenKillCount / (float)tierRoof * 89.0f), 11);
            guiGraphics.m_280488_(this.mc.f_91062_, f.format(killsToNextTier) + " to go", x + 3, y + 2 + this.barSpacing + index * this.componentHeight, 0xFFFFFF);
        }
    }

    private void drawItemStack(GuiGraphics guiGraphics, int x, int y, ItemStack stack) {
        guiGraphics.m_280480_(stack, x, y);
    }

    private int getLeftCornerX() {
        return 5;
    }

    private int getRightCornerX() {
        return Minecraft.m_91087_().m_91268_().m_85445_() - this.f_96543_ - 5;
    }

    private int getBottomY(int numberOfBars) {
        return Minecraft.m_91087_().m_91268_().m_85446_() - numberOfBars * this.componentHeight;
    }
}

