/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.providers;

import jp.artan.artansprojectcoremod.forge.providers.AbstractUDLanguageProvider;
import jp.artan.artansprojectcoremod.utils.lang.LangUtils;
import jp.artan.dmlreloaded.init.DMLCreativeTab;
import jp.artan.dmlreloaded.init.DMLItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;

public class ModUDLanguageProvider
extends AbstractUDLanguageProvider {
    private final String modid;

    public ModUDLanguageProvider(PackOutput output, String modid) {
        super(output, modid);
        this.modid = modid;
    }

    protected void addTranslations() {
        BuiltInRegistries.f_256975_.m_123024_().filter(block -> this.modid.equals(BuiltInRegistries.f_256975_.m_7981_(block).m_135827_())).forEach(block -> {
            String blockId = BuiltInRegistries.f_256975_.m_7981_(block).m_135815_();
            this.add((Block)block, LangUtils.toUpsideDownEnglish((String)blockId));
        });
        BuiltInRegistries.f_257033_.m_123024_().filter(item -> this.modid.equals(BuiltInRegistries.f_257033_.m_7981_(item).m_135827_()) && (!(item instanceof BlockItem) || item instanceof ItemNameBlockItem)).forEach(item -> {
            if (item == DMLItems.GLITCH_UPGRADE_SMITHING_TEMPLATE.get()) {
                this.add((Item)item, LangUtils.toUpsideDownEnglish((String)"Smithing Template"));
            } else {
                String itemId = BuiltInRegistries.f_257033_.m_7981_(item).m_135815_();
                this.add((Item)item, LangUtils.toUpsideDownEnglish((String)itemId));
            }
        });
        BuiltInRegistries.f_256980_.m_123024_().filter(item -> this.modid.equals(BuiltInRegistries.f_256980_.m_7981_(item).m_135827_())).forEach(block -> {
            String potionId = BuiltInRegistries.f_256980_.m_7981_(block).m_135815_();
            this.add("item.minecraft.lingering_potion.effect." + potionId, LangUtils.toUpsideDownEnglish((String)("lingering_" + potionId + "_bottle")));
            this.add("item.minecraft.potion.effect." + potionId, LangUtils.toUpsideDownEnglish((String)(potionId + "_bottle")));
            this.add("item.minecraft.splash_potion.effect." + potionId, LangUtils.toUpsideDownEnglish((String)("splash_" + potionId + "_bottle")));
        });
        this.addTranslationsToolTip();
        this.addTranslationsCurios();
        this.addPatchouliLang();
        this.addTranslationJEI();
        this.addCreativeModeTab(DMLCreativeTab.DEEP_MOB_LEARNING_RELOADED, LangUtils.toUpsideDownEnglish((String)"Deep Mob Learning: Reloaded"));
    }

    private void addTranslationsToolTip() {
        this.add(this.createToolTip("data_model.data.collected"), LangUtils.toUpsideDownEnglish((String)"Data collected: %1$s/%2$s"));
        this.add(this.createToolTip("data_model.data.killmultiplier"), LangUtils.toUpsideDownEnglish((String)"Data per kill: %1$s"));
        this.add(this.createToolTip("data_model.rfcost"), LangUtils.toUpsideDownEnglish((String)"Simulation cost: %1$s RF/t"));
        this.add(this.createToolTip("data_model.tier"), LangUtils.toUpsideDownEnglish((String)"Tier: %1$s"));
        this.add(this.createToolTip("data_model.type_text"), LangUtils.toUpsideDownEnglish((String)"Type: %1$s"));
        this.add(this.createToolTip("data_model_upgrade.desc"), LangUtils.toUpsideDownEnglish((String)"Creative only"));
        this.add(this.createToolTip("data_model_upgrade.tier"), LangUtils.toUpsideDownEnglish((String)"Can be upgraded to data model grade%1$s."));
        this.add(this.createToolTip("deep_learner.data_model_slots"), LangUtils.toUpsideDownEnglish((String)"Data model stored in data model."));
        this.add(this.createToolTip("deep_learner.data_model_slots_empty"), LangUtils.toUpsideDownEnglish((String)"Nothing stored."));
        this.add(this.createToolTip("gui.deep_learner.collect_data"), LangUtils.toUpsideDownEnglish((String)"Your data models will collect data"));
        this.add(this.createToolTip("gui.deep_learner.hp"), LangUtils.toUpsideDownEnglish((String)"Life points"));
        this.add(this.createToolTip("gui.deep_learner.in_order"), LangUtils.toUpsideDownEnglish((String)"In order to collect data, you must"));
        this.add(this.createToolTip("gui.deep_learner.insert"), LangUtils.toUpsideDownEnglish((String)"Please insert a Data Model!"));
        this.add(this.createToolTip("gui.deep_learner.killing_blow"), LangUtils.toUpsideDownEnglish((String)"deliver the killing blow."));
        this.add(this.createToolTip("gui.deep_learner.max"), LangUtils.toUpsideDownEnglish((String)"Maximum tier achieved"));
        this.add(this.createToolTip("gui.deep_learner.not_found"), LangUtils.toUpsideDownEnglish((String)"No data model stored"));
        this.add(this.createToolTip("gui.deep_learner.overlay"), LangUtils.toUpsideDownEnglish((String)"%1$s Model"));
        this.add(this.createToolTip("gui.deep_learner.when_placed"), LangUtils.toUpsideDownEnglish((String)"when they are placed in the deep learner."));
        this.add(this.createToolTip("gui.defeated"), LangUtils.toUpsideDownEnglish((String)"%1$s defeated: %2$s"));
        this.add(this.createToolTip("gui.energy.energystored"), LangUtils.toUpsideDownEnglish((String)"%1$s/%2$s RF"));
        this.add(this.createToolTip("gui.extraction_chamber.opcost"), LangUtils.toUpsideDownEnglish((String)"Operational cost: %1$s RF/t"));
        this.add(this.createToolTip("gui.information"), LangUtils.toUpsideDownEnglish((String)"Information"));
        this.add(this.createToolTip("gui.mob.blaze.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Bring buckets, and watch in despair"));
        this.add(this.createToolTip("gui.mob.blaze.trivia.1"), LangUtils.toUpsideDownEnglish((String)"as it evaporates, and everything is on fire"));
        this.add(this.createToolTip("gui.mob.blaze.trivia.2"), LangUtils.toUpsideDownEnglish((String)"You are on fire"));
        this.add(this.createToolTip("gui.mob.creeper.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Will blow up your base if"));
        this.add(this.createToolTip("gui.mob.creeper.trivia.1"), LangUtils.toUpsideDownEnglish((String)"left unattended."));
        this.add(this.createToolTip("gui.mob.ender_dragon.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Resides in the end, does not harbor treasure"));
        this.add(this.createToolTip("gui.mob.ender_dragon.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Destroy its crystals, break the cycle."));
        this.add(this.createToolTip("gui.mob.enderman.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Friendly unless provoked, dislikes rain."));
        this.add(this.createToolTip("gui.mob.enderman.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Teleports short distances"));
        this.add(this.createToolTip("gui.mob.ghast.trivia.0"), LangUtils.toUpsideDownEnglish((String)"If you hear something that sounds like"));
        this.add(this.createToolTip("gui.mob.ghast.trivia.1"), LangUtils.toUpsideDownEnglish((String)"a crying llama, you're probably hearing a ghast"));
        this.add(this.createToolTip("gui.mob.guardian.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Lurking in the oceans."));
        this.add(this.createToolTip("gui.mob.guardian.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Uses some sort of sonar beam as"));
        this.add(this.createToolTip("gui.mob.guardian.trivia.2"), LangUtils.toUpsideDownEnglish((String)"a means of attack"));
        this.add(this.createToolTip("gui.mob.shulker.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Found in End cities"));
        this.add(this.createToolTip("gui.mob.shulker.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Sneaky little buggers"));
        this.add(this.createToolTip("gui.mob.skeleton.trivia.0"), LangUtils.toUpsideDownEnglish((String)"A formidable archer, which seem to be running"));
        this.add(this.createToolTip("gui.mob.skeleton.trivia.1"), LangUtils.toUpsideDownEnglish((String)"some sort of cheat engine"));
        this.add(this.createToolTip("gui.mob.skeleton.trivia.2"), LangUtils.toUpsideDownEnglish((String)"A shield could prove useful"));
        this.add(this.createToolTip("gui.mob.slime.trivia.0"), LangUtils.toUpsideDownEnglish((String)"The bounce"));
        this.add(this.createToolTip("gui.mob.slime.trivia.1"), LangUtils.toUpsideDownEnglish((String)"bounce his bounce"));
        this.add(this.createToolTip("gui.mob.slime.trivia.2"), LangUtils.toUpsideDownEnglish((String)"squish - \"A slime haiku\""));
        this.add(this.createToolTip("gui.mob.spider.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Nocturnal douchebags, beware"));
        this.add(this.createToolTip("gui.mob.spider.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Drops strands of string for some reason.."));
        this.add(this.createToolTip("gui.mob.witch.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Affinity with potions and concoctions"));
        this.add(this.createToolTip("gui.mob.witch.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Beware!"));
        this.add(this.createToolTip("gui.mob.wither.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Do not approach this enemy. Run!"));
        this.add(this.createToolTip("gui.mob.wither.trivia.1"), LangUtils.toUpsideDownEnglish((String)"I mean it has 3 heads, what could"));
        this.add(this.createToolTip("gui.mob.wither.trivia.2"), LangUtils.toUpsideDownEnglish((String)"possibly go wrong?"));
        this.add(this.createToolTip("gui.mob.wither_skeleton.trivia.0"), LangUtils.toUpsideDownEnglish((String)"Inflicts the wither effect"));
        this.add(this.createToolTip("gui.mob.wither_skeleton.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Bring milk"));
        this.add(this.createToolTip("gui.mob.zombie.trivia.0"), LangUtils.toUpsideDownEnglish((String)"They go moan in the night."));
        this.add(this.createToolTip("gui.mob.zombie.trivia.1"), LangUtils.toUpsideDownEnglish((String)"Does not understand the need for"));
        this.add(this.createToolTip("gui.mob.zombie.trivia.2"), LangUtils.toUpsideDownEnglish((String)"personal space"));
        this.add(this.createToolTip("gui.mob_name"), LangUtils.toUpsideDownEnglish((String)"The %1$s"));
        this.add(this.createToolTip("gui.name"), LangUtils.toUpsideDownEnglish((String)"Name"));
        this.add(this.createToolTip("gui.simulation_chamber.cannot_begin"), LangUtils.toUpsideDownEnglish((String)"Cannot begin simulation"));
        this.add(this.createToolTip("gui.simulation_chamber.collected"), LangUtils.toUpsideDownEnglish((String)"%1$s / %2$s Data collected"));
        this.add(this.createToolTip("gui.simulation_chamber.console.1"), LangUtils.toUpsideDownEnglish((String)"> Launching runtime"));
        this.add(this.createToolTip("gui.simulation_chamber.console.10"), LangUtils.toUpsideDownEnglish((String)"..."));
        this.add(this.createToolTip("gui.simulation_chamber.console.2"), LangUtils.toUpsideDownEnglish((String)"v1.4.7"));
        this.add(this.createToolTip("gui.simulation_chamber.console.3"), LangUtils.toUpsideDownEnglish((String)"> Iteration # %1$s started"));
        this.add(this.createToolTip("gui.simulation_chamber.console.4"), LangUtils.toUpsideDownEnglish((String)"> Loading model from chip memory"));
        this.add(this.createToolTip("gui.simulation_chamber.console.5"), LangUtils.toUpsideDownEnglish((String)"> Assessing threat level"));
        this.add(this.createToolTip("gui.simulation_chamber.console.6"), LangUtils.toUpsideDownEnglish((String)"> Engaged enemy"));
        this.add(this.createToolTip("gui.simulation_chamber.console.7"), LangUtils.toUpsideDownEnglish((String)"> Pristine procurement"));
        this.add(this.createToolTip("gui.simulation_chamber.console.8_failed"), LangUtils.toUpsideDownEnglish((String)"failed"));
        this.add(this.createToolTip("gui.simulation_chamber.console.8_succeeded"), LangUtils.toUpsideDownEnglish((String)"succeeded"));
        this.add(this.createToolTip("gui.simulation_chamber.console.9"), LangUtils.toUpsideDownEnglish((String)"> Processing results"));
        this.add(this.createToolTip("gui.simulation_chamber.drain"), LangUtils.toUpsideDownEnglish((String)"Simulations with current data model drains %1$s RF/t"));
        this.add(this.createToolTip("gui.simulation_chamber.insert"), LangUtils.toUpsideDownEnglish((String)"Please insert a data model"));
        this.add(this.createToolTip("gui.simulation_chamber.iterations"), LangUtils.toUpsideDownEnglish((String)"Iterations: %1$s"));
        this.add(this.createToolTip("gui.simulation_chamber.max_tier"), LangUtils.toUpsideDownEnglish((String)"This data model has reached the max tier."));
        this.add(this.createToolTip("gui.simulation_chamber.missing"), LangUtils.toUpsideDownEnglish((String)"Machine is missing a data model"));
        this.add(this.createToolTip("gui.simulation_chamber.missing_polymer"), LangUtils.toUpsideDownEnglish((String)"Missing polymer medium"));
        this.add(this.createToolTip("gui.simulation_chamber.pristine_chance"), LangUtils.toUpsideDownEnglish((String)"Pristine chance: %1$s%%"));
        this.add(this.createToolTip("gui.simulation_chamber.tier1.1"), LangUtils.toUpsideDownEnglish((String)"Insufficient data in model"));
        this.add(this.createToolTip("gui.simulation_chamber.tier1.2"), LangUtils.toUpsideDownEnglish((String)"please insert a basic model"));
        this.add(this.createToolTip("gui.simulation_chamber.tier1.3"), LangUtils.toUpsideDownEnglish((String)"or better "));
        this.add(this.createToolTip("gui.simulation_chamber.to_begin"), LangUtils.toUpsideDownEnglish((String)"to begin the simulation"));
        this.add(this.createToolTip("holdctrl"), LangUtils.toUpsideDownEnglish((String)"- hold %1$s for more info"));
        this.add(this.createToolTip("holdshift"), LangUtils.toUpsideDownEnglish((String)"- hold %1$s for more info"));
        this.add(this.createToolTip("hover_text.glitch_fragment_1"), LangUtils.toUpsideDownEnglish((String)"Crafted by crushing a %1$s"));
        this.add(this.createToolTip("hover_text.glitch_fragment_2"), LangUtils.toUpsideDownEnglish((String)"against some %1$s (Right click)"));
        this.add(this.createToolTip("hover_text.glitch_fragment_3"), LangUtils.toUpsideDownEnglish((String)"Yields 3 fragments per crushed heart"));
        this.add(this.createToolTip("hover_text.glitch_fragment_4"), LangUtils.toUpsideDownEnglish((String)"Can rarly drop from hostile mobs."));
        this.add(this.createToolTip("hover_text.glitch_heart"), LangUtils.toUpsideDownEnglish((String)"Drops from System Glitches"));
        this.add(this.createToolTip("hover_text.glitch_infused_armor_1"), LangUtils.toUpsideDownEnglish((String)"Bonus while full set is equipped"));
        this.add(this.createToolTip("hover_text.glitch_infused_armor_2"), LangUtils.toUpsideDownEnglish((String)"(Bonuses are disabled during Trials)"));
        this.add(this.createToolTip("hover_text.glitch_infused_armor_3"), LangUtils.toUpsideDownEnglish((String)"  1. Certain probability of drop Pristine Matter"));
        this.add(this.createToolTip("hover_text.glitch_infused_armor_4"), LangUtils.toUpsideDownEnglish((String)"     when a Data Model gains Data."));
        this.add(this.createToolTip("hover_text.glitch_infused_armor_5"), LangUtils.toUpsideDownEnglish((String)"  2. Flight & Immunity against fall damage"));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_1"), LangUtils.toUpsideDownEnglish((String)"Bonus: Quick learner"));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_2"), LangUtils.toUpsideDownEnglish((String)"(Bonuses are disabled during Trials)"));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_3"), LangUtils.toUpsideDownEnglish((String)"The Data gained from the demise of a mob is doubled,"));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_4"), LangUtils.toUpsideDownEnglish((String)"when Data is gained there is also a small chance"));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_5"), LangUtils.toUpsideDownEnglish((String)"that the sword will get a permanent damage increase."));
        this.add(this.createToolTip("hover_text.glitch_infused_sword_6"), LangUtils.toUpsideDownEnglish((String)"Current damage increase: %1$s (Max %2$s)"));
        this.add(this.createToolTip("hover_text.glitchingot_1"), LangUtils.toUpsideDownEnglish((String)"Made by stabilizing %1$s"));
        this.add(this.createToolTip("hover_text.more_info"), LangUtils.toUpsideDownEnglish((String)"more info found in JEI or the Guidebook"));
        this.add(this.createToolTip("hover_text.soot_covered_redstone_1"), LangUtils.toUpsideDownEnglish((String)"Crafted by crushing %1$s against"));
        this.add(this.createToolTip("hover_text.soot_covered_redstone_2"), LangUtils.toUpsideDownEnglish((String)"against some %1$s (Left click)"));
        this.add(this.createToolTip("learning_target"), LangUtils.toUpsideDownEnglish((String)"Learning Target Mobs"));
        this.add(this.createToolTip("living_matter.deeperdarker"), LangUtils.toUpsideDownEnglish((String)"Deeper Darker Matter"));
        this.add(this.createToolTip("living_matter.exp"), LangUtils.toUpsideDownEnglish((String)"Experience per item: %1$s"));
        this.add(this.createToolTip("living_matter.exp_consume"), LangUtils.toUpsideDownEnglish((String)"Can be consumed for expirience %1$s"));
        this.add(this.createToolTip("living_matter.exp_consume_stack"), LangUtils.toUpsideDownEnglish((String)"Hold %1$s to consume entire stack."));
        this.add(this.createToolTip("living_matter.extraterrestrial"), LangUtils.toUpsideDownEnglish((String)"Extraterrestrial"));
        this.add(this.createToolTip("living_matter.hellish"), LangUtils.toUpsideDownEnglish((String)"Hellish"));
        this.add(this.createToolTip("living_matter.overworldian"), LangUtils.toUpsideDownEnglish((String)"Overworldian"));
        this.add(this.createToolTip("messages.sword_levelup"), LangUtils.toUpsideDownEnglish((String)"Your %1$s grows in power!"));
        this.add(this.createToolTip("messages.sword_levelup.max"), LangUtils.toUpsideDownEnglish((String)"Your %1$s has now reached peak performance!"));
        this.add(this.createToolTip("tiers.increase_tier"), LangUtils.toUpsideDownEnglish((String)"%1$s reached the %2$s tier"));
        this.add(this.createToolTip("tiers.tier"), LangUtils.toUpsideDownEnglish((String)"Model Tier: %1$s"));
        this.add(this.createToolTip("tiers.tier_1"), LangUtils.toUpsideDownEnglish((String)"Faulty"));
        this.add(this.createToolTip("tiers.tier_2"), LangUtils.toUpsideDownEnglish((String)"Basic"));
        this.add(this.createToolTip("tiers.tier_3"), LangUtils.toUpsideDownEnglish((String)"Advanced"));
        this.add(this.createToolTip("tiers.tier_4"), LangUtils.toUpsideDownEnglish((String)"Superior"));
        this.add(this.createToolTip("tiers.tier_5"), LangUtils.toUpsideDownEnglish((String)"Self Aware"));
        this.add(this.createToolTip("tiers.tier_next"), LangUtils.toUpsideDownEnglish((String)"Defeat %1$s more to reach %2$s"));
        this.add(this.createToolTip("upgrade", "glitch_upgrade"), LangUtils.toUpsideDownEnglish((String)"Glitch Upgrade"));
        this.add(this.createToolTip("item", "smithing_template.glitch_upgrade.applies_to"), LangUtils.toUpsideDownEnglish((String)"Glitch Equipment"));
        this.add(this.createToolTip("item", "smithing_template.glitch_upgrade.ingredients"), LangUtils.toUpsideDownEnglish((String)"Netherite Glitch Infused Ingot"));
        this.add(this.createToolTip("item", "smithing_template.glitch_upgrade.base_slot_description"), LangUtils.toUpsideDownEnglish((String)"Add glitch armor, weapon, or tool"));
        this.add(this.createToolTip("item", "smithing_template.glitch_upgrade.additions_slot_description"), LangUtils.toUpsideDownEnglish((String)"Add Glitch Infused Ingot"));
    }

    private void addPatchouliLang() {
        this.add("patchouli.book.landing_text", LangUtils.toUpsideDownEnglish((String)"$(dml) adds new ways to acquire loot that normally drops from mobs, the intent is to remove the need for a big laggy mobfarm.$(br2)The mod is inspired by $(l:https://minecraft.curseforge.com/projects/soul-shards-respawn)Soul shards$() and $(l:https://minecraft.curseforge.com/projects/woot)Woot$().$(br2)This guide was written with $(l:https://minecraft.curseforge.com/projects/patchouli)Patchouli$(), a $(o)neat$() mod by $(l:https://twitter.com/Vazkii)Vazkii$()."));
        this.add("patchouli.book.sub_title", LangUtils.toUpsideDownEnglish((String)"A not-so comprehensive Guide"));
        this.add("patchouli.category.1.introduction.title", LangUtils.toUpsideDownEnglish((String)"Introduction"));
        this.add("patchouli.category.1.introduction.text", LangUtils.toUpsideDownEnglish((String)"This chapter will cover the basics of the $(item)Mod$() so you can start accumulating $(l:0_introduction/1_data)Data$() for your $(l:0_introduction/2_data_models#data_models)Data Models$()."));
        this.add("patchouli.category.1.introduction.entry.1.title", LangUtils.toUpsideDownEnglish((String)"Introduction"));
        this.add("patchouli.category.1.introduction.entry.1.page.1.text", LangUtils.toUpsideDownEnglish((String)"The design principle of this $(item)Mod$() is to be a simple and$(br)lag-free alternative to gathering mob resources by traditional means.$(br2)The mods mechanics encourage players to explore and engage in combat and benefit from it later on.$(br2)To get started you will need some specialized $(item)Crafting Components$()."));
        this.add("patchouli.category.1.introduction.entry.1.page.2.text", LangUtils.toUpsideDownEnglish((String)"$(item)Soot-covered Redstone$() can be created by crushing some $(item)Redstone$() against a $(item)Block of Coal$().$(br2)This sooty marvel will be required to craft most things this $(item)Mod$() has to offer."));
        this.add("patchouli.category.1.introduction.entry.2.title", LangUtils.toUpsideDownEnglish((String)"Data"));
        this.add("patchouli.category.1.introduction.entry.2.page.1.text", LangUtils.toUpsideDownEnglish((String)"Before you can start reaping the rewards you will need to collect some $(item)Data$() about a mob, the handheld device that makes that possible is called the $(item)Deep Learner$().$(br2)The $(item)Deep Learner$() is a device that can detect whenever you deliver mortal harm to a mob."));
        this.add("patchouli.category.1.introduction.entry.2.page.2.text", LangUtils.toUpsideDownEnglish((String)"It can turn your encounter with that mob into $(item)Data$() if you have a $(l:0_introduction/2_data_models)Data model$() attached to the $(item)Deep Learner$().$(br2)The $(item)Deep Learner$() Can have 4 attached $(l:0_introduction/2_data_models)Data Models$() at any given time."));
        this.add("patchouli.category.1.introduction.entry.2.page.3.text", LangUtils.toUpsideDownEnglish((String)"If you hold the $(item)Deep Learner$() in your $(item)Mainhand$() or $(item)Offhand$() a HUD will be displayed showing you how much more $(item)Data$() you need before you reach the next $(l:0_introduction/2_data_models)Data Model$() $(item)Tier$()."));
        this.add("patchouli.category.1.introduction.entry.3.title", LangUtils.toUpsideDownEnglish((String)"Data Models"));
        this.add("patchouli.category.1.introduction.entry.3.page.1.text", LangUtils.toUpsideDownEnglish((String)"You can craft a $(item)Blank Data Model$() with some of that$(br)$(l:0_introduction/0_introduction#sooted_redstone)Soot-covered Redstone$() you made earlier."));
        this.add("patchouli.category.1.introduction.entry.3.page.2.text", LangUtils.toUpsideDownEnglish((String)"All of the $(item)Data Models$() start at the \\\"$(8)Faulty$()\\\" tier, this tier goes up as the $(item)Data Models$() gather more $(item)Data$().$(br2)As you $(item)Tier$() up you will gain more $(item)Data$() from the mobs you defeat.$(br2)$(item)Data Models$() can be put inside a $(l:1_machines/0_simulation_chamber)Simulation chamber$()"));
        this.add("patchouli.category.1.introduction.entry.3.page.3.text", LangUtils.toUpsideDownEnglish((String)"$(item)Data Models$() are split into $(item)Types$() depending on their $(item)Habitat$().$(br2)The basic $(item)Habitats$() are: $(a)Overworldian$(), $(c)Hellish$() and $(d)Extraterrestrial$().$(br2)The type of the $(item)Data Model$() will determine what kind of $(l:1_machines/1_matter#living)Living Matter$() and $(l:1_machines/1_matter#pristine)Pristine Matter$() the $(l:1_machines/0_simulation_chamber)Simulation Chamber$() will produce."));
        this.add("patchouli.category.1.introduction.entry.3.page.4.title", LangUtils.toUpsideDownEnglish((String)"Zombie / Skeleton"));
        this.add("patchouli.category.1.introduction.entry.3.page.5.title", LangUtils.toUpsideDownEnglish((String)"Creeper / Spider"));
        this.add("patchouli.category.1.introduction.entry.3.page.6.title", LangUtils.toUpsideDownEnglish((String)"Slime / Witch"));
        this.add("patchouli.category.1.introduction.entry.3.page.7.title", LangUtils.toUpsideDownEnglish((String)"Blaze / Ghast"));
        this.add("patchouli.category.1.introduction.entry.3.page.8.title", LangUtils.toUpsideDownEnglish((String)"Wither Skeleton / Enderman"));
        this.add("patchouli.category.1.introduction.entry.3.page.9.title", LangUtils.toUpsideDownEnglish((String)"Wither / Ender Dragon"));
        this.add("patchouli.category.1.introduction.entry.3.page.10.title", LangUtils.toUpsideDownEnglish((String)"Shulker / Guardian"));
        this.add("patchouli.category.1.introduction.entry.3.page.11.title", LangUtils.toUpsideDownEnglish((String)"Elder Guardian / Evoker"));
        this.add("patchouli.category.1.introduction.entry.3.page.12.title", LangUtils.toUpsideDownEnglish((String)"Hoglin / Magma Cube"));
        this.add("patchouli.category.1.introduction.entry.3.page.13.title", LangUtils.toUpsideDownEnglish((String)"Phantom / Piglin"));
        this.add("patchouli.category.1.introduction.entry.3.page.14.title", LangUtils.toUpsideDownEnglish((String)"Ravager"));
        this.add("patchouli.category.2.introduction.title", LangUtils.toUpsideDownEnglish((String)"Machines"));
        this.add("patchouli.category.2.introduction.text", LangUtils.toUpsideDownEnglish((String)"This chapter will teach you everything you need to know about the machines$(br)in $(dml)$(br2)All $(item)Machines$() accepts $(item)Inputs$() from the top of the block. The other sides are used to pipe $(item)Outputs$()."));
        this.add("patchouli.category.2.introduction.entry.1.title", LangUtils.toUpsideDownEnglish((String)"Simulation Chamber"));
        this.add("patchouli.category.2.introduction.entry.1.page.1.text", LangUtils.toUpsideDownEnglish((String)"The $(item)Simulation Chamber$() is a machine that can read the information stored on your $(l:0_introduction/2_data_models)Data Models$() and from that $(l:0_introduction/1_data)Data$() create $(l:1_machines/1_matter)Matter$().$(br2)This process will add more $(l:0_introduction/1_data)Data$() to the $(l:0_introduction/2_data_models)Data Model$() currently being used.$(br2)This process also requires a $(a)Basic$() (or higher) tier$(br)$(l:0_introduction/2_data_models)Data Model$(), $(l:1_machines/3_energy)Energy$() and$(br)$(item)Polymer Clay$()."));
        this.add("patchouli.category.2.introduction.entry.1.page.2.text", LangUtils.toUpsideDownEnglish((String)"The $(item)Simulation Chamber$() is crafted with a $(l:0_introduction/0_introduction#plates_and_casings)Sooted Machine Casing$().$(br2)The operational $(item)Energy$() cost depends on what $(l:0_introduction/2_data_models)Data Model$() is used."));
        this.add("patchouli.category.2.introduction.entry.1.page.3.text", LangUtils.toUpsideDownEnglish((String)"$(item)Polymer Clay$() is a very soft and adept clay that can take on most shapes.$(br2)In the $(item)Simulation Chamber$() its used as a binding agent to create $(l:1_machines/1_matter)Matter$()"));
        this.add("patchouli.category.2.introduction.entry.2.title", LangUtils.toUpsideDownEnglish((String)"Matter"));
        this.add("patchouli.category.2.introduction.entry.2.page.1.text", LangUtils.toUpsideDownEnglish((String)"There are two kinds of $(item)Matter$(), $(item)Living$() and $(item)Pristine$().$(br2)You will always get one$(br2)$(item)Living Matter$() from running a $(l:1_machines/0_simulation_chamber)Simulation$().$(br2)There is also a chance to produce $(item)Pristine Matter$(), the chance depends on the $(item)Tier$() of the $(l:0_introduction/2_data_models#data_models)Data Model$() currently in the $(l:1_machines/0_simulation_chamber)Simulation Chamber$()."));
        this.add("patchouli.category.2.introduction.entry.2.page.2.title", LangUtils.toUpsideDownEnglish((String)"Living Matter"));
        this.add("patchouli.category.2.introduction.entry.2.page.2.text", LangUtils.toUpsideDownEnglish((String)"$(item)Living Matter$() is a versatile matter that can be used to $(item)Transmute$() ingredients local to that $(item)Habitat$(), check $(item)JEI$() to see what recipes are available.$(br2)You can also consume $(item)Living Matter$() to gain $(item)Experience$()."));
        this.add("patchouli.category.2.introduction.entry.2.page.3.title", LangUtils.toUpsideDownEnglish((String)"Example Transmutes"));
        this.add("patchouli.category.2.introduction.entry.2.page.4.title", LangUtils.toUpsideDownEnglish((String)"Pristine Matter"));
        this.add("patchouli.category.2.introduction.entry.2.page.4.text", LangUtils.toUpsideDownEnglish((String)"Secondary output from the $(l:1_machines/0_simulation_chamber)Simulation Chamber$().$(br2)The type of $(item)Pristine Matter$() you will produce depends on the type of the $(l:0_introduction/2_data_models#data_models)Data Model$().$(br2)$(item)Pristine Matter$() will produce mob drops in the$(br)$(l:1_machines/2_loot_fabricator)Loot Fabricator$()."));
        this.add("patchouli.category.2.introduction.entry.3.title", LangUtils.toUpsideDownEnglish((String)"Loot Fabricator"));
        this.add("patchouli.category.2.introduction.entry.3.page.1.text", LangUtils.toUpsideDownEnglish((String)"The $(item)Loot Fabricator$() is a machine that can well.... $(item)Fabricate Loot$() from the various accessible $(item)Pristine Matters$().$(br2)This process requires $(l:1_machines/3_energy)Energy$() aswell as a selected $(item)Item$() to produce $(item)Loot$()."));
        this.add("patchouli.category.2.introduction.entry.3.page.2.text", LangUtils.toUpsideDownEnglish((String)"The selected $(item)Item$() will be remembered for automation puposes, it will stay selected until its unselected."));
        this.add("patchouli.category.2.introduction.entry.4.title", LangUtils.toUpsideDownEnglish((String)"Energy"));
        this.add("patchouli.category.2.introduction.entry.4.page.1.title", LangUtils.toUpsideDownEnglish((String)"Energy"));
        this.add("patchouli.category.2.introduction.entry.4.page.1.text", LangUtils.toUpsideDownEnglish((String)"This mod adds no way of producing $(item)Energy$(), so you will need some sort of $(item)Generator$() from another mod to power the $(item)Machines$()."));
        this.add("patchouli.category.2.introduction.entry.4.page.2.title", LangUtils.toUpsideDownEnglish((String)"Power Units"));
        this.add("patchouli.category.2.introduction.entry.4.page.2.text", LangUtils.toUpsideDownEnglish((String)"Both $(item)Forge Energy (FE)$() and $(item)Redstone Flux (RF)$() will work.$(br2)Below are some example mods that could work to power your $(item)Machines$().$(br2)$(l:https://www.curseforge.com/minecraft/mc-mods/simple-generators)Simple Generators$() (Misc)$(br)$(l:https://www.curseforge.com/minecraft/mc-mods/mekanism-generators)Mekanism Generators$() (Reactors)$(br)$(l:https://minecraft.curseforge.com/projects/advanced-generators)Advanced Generators$()"));
    }

    private void addTranslationsCurios() {
        this.add("curios.identifier.deep_learner", LangUtils.toUpsideDownEnglish((String)"Deep Learner"));
    }

    private void addTranslationJEI() {
        this.add("jei.dmlreloaded.glitch_ingot", LangUtils.toUpsideDownEnglish((String)"TLDR: Drop some fragments, lapis and gold ingots into a body of water and hope for the best\\n\\nYou've found that lapis is a good stabilization agent for Unstable glitch fragments.\\nAfter the fragments are stable, they desperately seek out a material to latch on to, you think that gold might be strong enough as a host.\\n\\nThe entire process is delicate, it needs to be performed in water or the materials wont bind properly."));
    }

    private String createToolTip(String parent, String key) {
        return parent + ".dmlreloaded." + key;
    }

    private String createToolTip(String key) {
        return "dmlreloaded." + key;
    }
}

