/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.plugin.jei.category;

import jp.artan.dmlreloaded.DeepMobLearningReloadedMod;
import jp.artan.dmlreloaded.forge.init.DMLBlocksForge;
import jp.artan.dmlreloaded.init.DMLItems;
import jp.artan.dmlreloaded.util.DataModelHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SimulationChamberRecipeCategory
implements IRecipeCategory<SimulationChamberRecipes> {
    public static MutableComponent title = Component.m_237115_((String)"block.dmlreloaded.simulation_chamber");
    public static RecipeType<SimulationChamberRecipes> type = RecipeType.create((String)"dmlreloaded", (String)"simulation_chamber", SimulationChamberRecipes.class);
    private IDrawable icon;
    private IDrawable background;
    private IDrawableAnimated progress;

    public SimulationChamberRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation base = DeepMobLearningReloadedMod.getResource("textures/gui/jei/simulation_chamber.png");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)DMLBlocksForge.SIMULATION_CHAMBER.get()));
        this.background = guiHelper.createDrawable(base, 0, 0, 116, 43);
        IDrawableStatic progressStatic = guiHelper.createDrawable(base, 0, 43, 35, 6);
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SimulationChamberRecipes recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 4).addItemStack(recipe.getDataModel());
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 4).addItemStack(new ItemStack((ItemLike)DMLItems.POLYMER_CLAY.get()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 4).addItemStack(recipe.getMatter());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 26).addItemStack(recipe.getPristine());
    }

    public Component getTitle() {
        return title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(SimulationChamberRecipes recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.progress.draw(guiGraphics, 52, 9);
    }

    public RecipeType<SimulationChamberRecipes> getRecipeType() {
        return type;
    }

    public static class SimulationChamberRecipes {
        private ItemStack pristine;
        private ItemStack data;
        private ItemStack matter;

        public SimulationChamberRecipes(ItemStack data) {
            this.data = data;
            this.pristine = DataModelHelper.getMobMetaData(data).getPristineMatterStack(1);
            this.matter = DataModelHelper.getMobMetaData(data).getLivingMatterStack(1);
        }

        public ItemStack getPristine() {
            return this.pristine;
        }

        public ItemStack getDataModel() {
            return this.data;
        }

        public ItemStack getMatter() {
            return this.matter;
        }
    }
}

