/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.plugin.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.artan.dmlreloaded.forge.init.DMLBlocksForge;
import jp.artan.dmlreloaded.forge.plugin.jei.DeepMobLearningReloadedRecipeCategoryUid;
import jp.artan.dmlreloaded.forge.plugin.jei.category.ExtractionChamberRecipeCategory;
import jp.artan.dmlreloaded.forge.plugin.jei.category.SimulationChamberRecipeCategory;
import jp.artan.dmlreloaded.forge.plugin.jei.maker.CraftingRecipeMaker;
import jp.artan.dmlreloaded.init.DMLItems;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import jp.artan.dmlreloaded.util.DataModelHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return DeepMobLearningReloadedRecipeCategoryUid.pluginUid;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SimulationChamberRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractionChamberRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, CraftingRecipeMaker.getCraftingRecipes());
        this.addSimulationChamberRecipe(registration);
        this.addExtractionChamberRecipe(registration);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DMLItems.GLITCH_INGOT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.dmlreloaded.glitch_ingot")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DMLBlocksForge.SIMULATION_CHAMBER.get()), new RecipeType[]{SimulationChamberRecipeCategory.type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DMLBlocksForge.EXTRACTION_CHAMBER.get()), new RecipeType[]{ExtractionChamberRecipeCategory.type});
    }

    private void addSimulationChamberRecipe(IRecipeRegistration registration) {
        ArrayList list = Lists.newArrayList();
        ForgeRegistries.ITEMS.getEntries().forEach(hashMapItem -> {
            Object patt2961$temp = hashMapItem.getValue();
            if (patt2961$temp instanceof ItemDataModel) {
                ItemDataModel dataModel = (ItemDataModel)((Object)((Object)patt2961$temp));
                ItemStack dataStack = new ItemStack((ItemLike)dataModel);
                DataModelHelper.setTier(dataStack, 1);
                list.add(new SimulationChamberRecipeCategory.SimulationChamberRecipes(dataStack));
            }
        });
        registration.addRecipes(SimulationChamberRecipeCategory.type, (List)list);
    }

    private void addExtractionChamberRecipe(IRecipeRegistration registration) {
        HashMap<ItemStack, List> pristineTables = new HashMap<ItemStack, List>();
        ArrayList list = Lists.newArrayList();
        ForgeRegistries.ITEMS.getEntries().forEach(hashMapItem -> {
            Object patt3719$temp = hashMapItem.getValue();
            if (patt3719$temp instanceof ItemPristineMatter) {
                ItemPristineMatter matter = (ItemPristineMatter)((Object)((Object)patt3719$temp));
                pristineTables.put(new ItemStack((ItemLike)matter, 1), matter.getMobKey().getLoot());
            }
        });
        pristineTables.forEach((input, outputs) -> outputs.forEach(output -> list.add(new ExtractionChamberRecipeCategory.ExtractionChamberRecipes((ItemStack)input, (ItemStack)output.get()))));
        registration.addRecipes(ExtractionChamberRecipeCategory.type, (List)list);
    }
}

