/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.network;

import java.util.function.Supplier;
import jp.artan.dmlreloaded.forge.block.entity.BlockEntityExtractionChamber;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundResultingItemPacket {
    public final ItemStack stack;
    public final BlockPos bPos;
    public final int index;
    public final boolean selected;

    public ServerboundResultingItemPacket(BlockPos pos, ItemStack stack, int index, boolean pSelected) {
        this.bPos = pos;
        this.stack = stack;
        this.index = index;
        this.selected = pSelected;
    }

    public ServerboundResultingItemPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.m_130267_(), buffer.readInt(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.bPos);
        buffer.m_130055_(this.stack);
        buffer.writeInt(this.index);
        buffer.writeBoolean(this.selected);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(this.bPos);
            if (blockEntity instanceof BlockEntityExtractionChamber) {
                BlockEntityExtractionChamber eCham = (BlockEntityExtractionChamber)blockEntity;
                eCham.setResultingItem(this.stack);
                eCham.setResultingIndex(this.index);
                eCham.setSelected(this.selected);
                eCham.finishCraft(true);
                eCham.update();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

