/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import jp.artan.dmlreloaded.common.mobmetas.MobMetaData;
import jp.artan.dmlreloaded.config.BalanceConfigs;
import jp.artan.dmlreloaded.forge.init.DMLItemsForge;
import jp.artan.dmlreloaded.forge.init.DropModifier;
import jp.artan.dmlreloaded.forge.item.ItemDeepLearner;
import jp.artan.dmlreloaded.forge.plugin.PluginInit;
import jp.artan.dmlreloaded.forge.plugin.curios.CuriosUtil;
import jp.artan.dmlreloaded.init.DMLItems;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemGlitchArmor;
import jp.artan.dmlreloaded.util.DataModelHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class GlitchFragmentModifier
extends LootModifier {
    private final Item fragment = (Item)DMLItemsForge.GLITCH_FRAGMENT.get();
    private final Item heart = (Item)DMLItems.GLITCH_HEART.get();
    private final int chanceFragment;
    private final float chanceHeart;
    private final boolean enabled;

    public GlitchFragmentModifier(LootItemCondition[] conditionsIn) {
        this(conditionsIn, 3, 0.5f, true);
    }

    public GlitchFragmentModifier(LootItemCondition[] conditionsIn, int chanceFragment, float chanceHeart, boolean enabled) {
        super(conditionsIn);
        this.chanceFragment = chanceFragment;
        this.chanceHeart = chanceHeart;
        this.enabled = enabled;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext ctx) {
        Object player2;
        if (this.enabled && ctx.m_78953_(LootContextParams.f_81455_) instanceof Enemy) {
            Object object;
            if (ThreadLocalRandom.current().nextInt(1, 100) <= this.chanceFragment) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.fragment, ThreadLocalRandom.current().nextInt(1, 3)));
            }
            if (ThreadLocalRandom.current().nextFloat(0.0f, 100.0f) <= this.chanceHeart) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.heart, 1));
            }
            if ((object = ctx.m_78953_(LootContextParams.f_81458_)) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)object;
                NonNullList<ItemStack> updatedModels = GlitchFragmentModifier.updateDataModel(ctx, player2);
                if (updatedModels.size() == 0) {
                    return generatedLoot;
                }
                if (((Boolean)BalanceConfigs.isGlitchArmorExtraDropsEnabled.get()).booleanValue() && ItemGlitchArmor.isSetEquippedByPlayer(player2) && ThreadLocalRandom.current().nextInt(1, 100) <= 16) {
                    MobMetaData meta = DataModelHelper.getMobMetaData((ItemStack)updatedModels.get(0));
                    generatedLoot.add((Object)meta.getPristineMatterStack(2));
                }
            }
        } else if (this.enabled && ctx.m_78953_(LootContextParams.f_81455_) instanceof Animal && (player2 = ctx.m_78953_(LootContextParams.f_81458_)) instanceof ServerPlayer) {
            ServerPlayer player3 = (ServerPlayer)player2;
            NonNullList<ItemStack> updatedModels = GlitchFragmentModifier.updateDataModel(ctx, player3);
            if (updatedModels.size() == 0) {
                return generatedLoot;
            }
            if (((Boolean)BalanceConfigs.isGlitchArmorExtraDropsEnabled.get()).booleanValue() && ItemGlitchArmor.isSetEquippedByPlayer(player3) && ThreadLocalRandom.current().nextInt(1, 100) <= 16) {
                MobMetaData meta = DataModelHelper.getMobMetaData((ItemStack)updatedModels.get(0));
                generatedLoot.add((Object)meta.getPristineMatterStack(2));
            }
        }
        return generatedLoot;
    }

    private static NonNullList<ItemStack> updateDataModel(LootContext ctx, ServerPlayer player) {
        NonNullList inventory = NonNullList.m_122779_();
        inventory.addAll((Collection)player.m_150109_().f_35974_);
        inventory.addAll((Collection)player.m_150109_().f_35976_);
        if (PluginInit.CURIOS_ACTIVE) {
            inventory.add((Object)CuriosUtil.getDeepLearnerCurioItemStack((Player)player));
        }
        NonNullList<ItemStack> deepLearners = GlitchFragmentModifier.getDeepLearners((NonNullList<ItemStack>)inventory);
        NonNullList updatedModels = NonNullList.m_122779_();
        deepLearners.forEach(stack -> {
            NonNullList<ItemStack> models = GlitchFragmentModifier.updateAndReturnModels(stack, (LivingEntity)ctx.m_78953_(LootContextParams.f_81455_), player);
            updatedModels.addAll(models);
        });
        return updatedModels;
    }

    private static NonNullList<ItemStack> updateAndReturnModels(ItemStack deepLearner, LivingEntity entity, ServerPlayer player) {
        NonNullList<ItemStack> deepLearnerItems = ItemDeepLearner.getContainedItems(deepLearner);
        NonNullList result = NonNullList.m_122779_();
        deepLearnerItems.forEach(stack -> {
            MobMetaData meta;
            if (stack.m_41720_() instanceof ItemDataModel && (meta = DataModelHelper.getMobMetaData(stack)).entityLivingMatchesMob(entity)) {
                DataModelHelper.increaseMobKillCount(stack, player);
                result.add(stack);
            }
            ItemDeepLearner.setContainedItems(deepLearner, deepLearnerItems);
        });
        return result;
    }

    private static NonNullList<ItemStack> getDeepLearners(NonNullList<ItemStack> inventory) {
        NonNullList result = NonNullList.m_122779_();
        inventory.forEach(stack -> {
            if (stack.m_41720_() instanceof ItemDeepLearner) {
                result.add(stack);
            }
        });
        return result;
    }

    public Codec<GlitchFragmentModifier> codec() {
        return (Codec)DropModifier.GLITCH_FRAGMENT.get();
    }

    public static RegistryObject<Codec<GlitchFragmentModifier>> create() {
        return DropModifier.GLM.register("glitch_fragment_all_entities", () -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GlitchFragmentModifier::new)));
    }
}

