/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.item;

import java.util.List;
import javax.annotation.Nonnull;
import jp.artan.dmlreloaded.forge.container.DeepLearnerContainer;
import jp.artan.dmlreloaded.forge.init.DMLContainersForge;
import jp.artan.dmlreloaded.forge.util.InventoryItemStack;
import jp.artan.dmlreloaded.util.DataModelHelper;
import jp.artan.dmlreloaded.util.ItemBackedInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemDeepLearner
extends Item {
    protected InventoryItemStack deepLearnerCont;
    public final int internalSlotSize;
    public final int squareSlotSize;

    public ItemDeepLearner(Item.Properties properties, int internalSlotSize) {
        super(properties);
        this.internalSlotSize = internalSlotSize;
        this.squareSlotSize = (int)Math.sqrt(internalSlotSize);
        this.deepLearnerCont = new InventoryItemStack(this.internalSlotSize);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            NonNullList<ItemStack> dataModels = DataModelHelper.getValidFromList(ItemDeepLearner.getContainedItems(stack));
            if (dataModels.isEmpty()) {
                list.add((Component)Component.m_237115_((String)"dmlreloaded.deep_learner.data_model_slots_empty"));
            } else {
                list.add((Component)Component.m_237115_((String)"dmlreloaded.deep_learner.data_model_slots"));
                for (int i = 0; i < dataModels.size(); ++i) {
                    list.add((Component)Component.m_237110_((String)"%1$s. %2$s", (Object[])new Object[]{i + 1, ((ItemStack)dataModels.get(i)).m_41720_().m_41466_()}));
                }
            }
        } else {
            list.add((Component)Component.m_237110_((String)"dmlreloaded.holdshift", (Object[])new Object[]{Component.m_237113_((String)"SHIFT").m_130938_(t -> t.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(true)))}).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY)));
        }
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237115_((String)super.m_7626_(p_41458_).getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, final Player player, final InteractionHand hand) {
        if (!world.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player2) {
                    return new DeepLearnerContainer((MenuType)DMLContainersForge.DEEP_LEARNER.get(), windowId, inv, player2.m_21120_(hand));
                }

                public Component m_5446_() {
                    return player.m_21120_(hand).m_41611_();
                }
            }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static SimpleContainer getInventory(ItemStack deepLearner) {
        ItemDeepLearner deepLearnerItem = (ItemDeepLearner)deepLearner.m_41720_();
        return new ItemBackedInventory(deepLearner, deepLearnerItem.internalSlotSize){

            public boolean m_7013_(int slot, @Nonnull ItemStack stack) {
                return ItemDeepLearner.isValid(slot, stack);
            }
        };
    }

    public static boolean isValid(int slot, ItemStack stack) {
        Item itm = stack.m_41720_();
        if (slot < 9) {
            return itm instanceof ItemDeepLearner;
        }
        return false;
    }

    public static NonNullList<ItemStack> getContainedItems(ItemStack deepLearner) {
        CompoundTag currentTag;
        ItemDeepLearner deepLearnerItem = (ItemDeepLearner)deepLearner.m_41720_();
        NonNullList list = NonNullList.m_122780_((int)deepLearnerItem.internalSlotSize, (Object)ItemStack.f_41583_);
        if (deepLearner.m_41782_() && (currentTag = deepLearner.m_41783_()).m_128441_("inventory")) {
            ListTag inventory = deepLearner.m_41783_().m_128437_("inventory", 10);
            for (int i = 0; i < deepLearnerItem.internalSlotSize; ++i) {
                CompoundTag tag = inventory.m_128728_(i);
                list.set(i, (Object)ItemStack.m_41712_((CompoundTag)tag));
            }
        }
        return list;
    }

    public static void setContainedItems(ItemStack deepLearner, NonNullList<ItemStack> list) {
        ListTag inventory = new ListTag();
        for (ItemStack stack : list) {
            CompoundTag tag = new CompoundTag();
            stack.m_41739_(tag);
            inventory.add((Object)tag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", (Tag)inventory);
        deepLearner.m_41751_(tag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return this.deepLearnerCont;
    }
}

