/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.init;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import jp.artan.dmlreloaded.forge.block.BlockExtractionChamber;
import jp.artan.dmlreloaded.forge.block.BlockSimulationChamber;
import jp.artan.dmlreloaded.init.DMLCreativeTab;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class DMLBlocksForge {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"dmlreloaded", (ResourceKey)Registries.f_256747_);
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"dmlreloaded", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<Block> MACHINE_CASING = DMLBlocksForge.register("machine_casing", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<BlockSimulationChamber> SIMULATION_CHAMBER = DMLBlocksForge.register("simulation_chamber", () -> new BlockSimulationChamber(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(4.0f, 3000.0f).m_60953_(blockstate -> 7)));
    public static final RegistrySupplier<BlockExtractionChamber> EXTRACTION_CHAMBER = DMLBlocksForge.register("extraction_chamber", () -> new BlockExtractionChamber(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(4.0f, 10.0f).m_60953_(blockstate -> 15)));
    public static final RegistrySupplier<Block> INFUSED_INGOT_BLOCK = DMLBlocksForge.register("infused_ingot_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));

    public static void register() {
        BLOCKS.register();
        ITEMS.register();
    }

    private static <T extends Block> RegistrySupplier<T> register(String name, Supplier<T> block) {
        RegistrySupplier registeredBlock = BLOCKS.register(name, block);
        ITEMS.register(name, () -> {
            BlockItem itemInstance = new BlockItem((Block)registeredBlock.get(), new Item.Properties());
            CreativeTabRegistry.append(DMLCreativeTab.DEEP_MOB_LEARNING_RELOADED, (ItemLike[])new ItemLike[]{itemInstance});
            return itemInstance;
        });
        return registeredBlock;
    }
}

