/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.container;

import jp.artan.dmlreloaded.forge.init.DMLItemsForge;
import jp.artan.dmlreloaded.forge.item.ItemDeepLearner;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.util.ItemBackedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DeepLearnerContainer
extends AbstractContainerMenu {
    protected Player player;
    protected InteractionHand usedHand;
    protected ItemStack deepLearner;
    public final Container deepLearnerInv;

    public static DeepLearnerContainer fromNetwork(MenuType<?> menuType, int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new DeepLearnerContainer(menuType, windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public DeepLearnerContainer(MenuType<?> menuType, int id, Inventory playerInv, ItemStack deepLearner) {
        super(menuType, id);
        ItemStack heldItem;
        ContainerLevelAccess.m_39289_((Level)playerInv.f_35978_.m_9236_(), (BlockPos)BlockPos.f_121853_);
        this.player = playerInv.f_35978_;
        this.usedHand = this.player.m_21205_().m_41720_() instanceof ItemDeepLearner ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.deepLearner = heldItem = this.player.m_21205_().m_41720_() instanceof ItemDeepLearner ? this.player.m_21205_() : this.player.m_21206_();
        this.deepLearner = deepLearner;
        this.deepLearnerInv = !playerInv.f_35978_.m_9236_().f_46443_ ? ItemDeepLearner.getInventory(deepLearner) : new ItemBackedInventory(deepLearner, this.getInternalSlotSize());
        this.addInventorySlots();
        this.addDataModelSlots();
    }

    private void addDataModelSlots() {
        int loopCount = ((ItemDeepLearner)this.deepLearner.m_41720_()).squareSlotSize;
        int index = 0;
        for (int column = 0; column < loopCount; ++column) {
            for (int row = 0; row < loopCount; ++row) {
                this.m_38897_(new Slot(this.deepLearnerInv, index, 193 - row * 18, 82 - column * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return !stack.m_41619_() && stack.m_41720_() instanceof ItemDataModel;
                    }

                    public int m_6641_() {
                        return 1;
                    }
                });
                ++index;
            }
        }
    }

    private void addInventorySlots() {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 8 + column * 18;
                int y = 119 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot = new Slot((Container)this.player.m_150109_(), index, x, y);
                this.m_38897_(slot);
            }
        }
        for (row = 0; row < 9; ++row) {
            Slot slot = new Slot((Container)this.player.m_150109_(), row, 8 + row * 18, 177);
            this.m_38897_(slot);
        }
    }

    public boolean m_6875_(Player player) {
        boolean isMainHand = this.isDataModel(player.m_21205_());
        boolean isOffHand = this.isDataModel(player.m_21206_());
        return isMainHand || isOffHand;
    }

    private boolean isDataModel(ItemStack stack) {
        return stack.m_41720_() == DMLItemsForge.DEEP_LEARNER.get() || stack.m_41720_() == DMLItemsForge.NETHERITE_DEEP_LEARNER.get();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack retStack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            retStack = item.m_41777_();
            if (index < 36 ? !this.m_38903_(item, 36, this.f_38839_.size(), true) : !this.m_38903_(item, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return retStack;
    }

    public Container getDeepInv() {
        return this.deepLearnerInv;
    }

    public int getInternalSlotSize() {
        ItemDeepLearner deepLearnerItem = (ItemDeepLearner)this.deepLearner.m_41720_();
        return deepLearnerItem.internalSlotSize;
    }
}

