/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.block.entity;

import jp.artan.dmlreloaded.forge.util.BaseStackHandler;
import jp.artan.dmlreloaded.forge.util.OutputStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryBlockEntity
extends BlockEntity {
    public final int size;
    protected int timer;
    public final BaseStackHandler inventory;
    protected LazyOptional<ItemStackHandler> handler;

    public InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int size, Integer[] arr) {
        super(type, pos, state);
        if (size <= 0) {
            size = 1;
        }
        this.size = size;
        this.inventory = this.createInventory();
        this.handler = LazyOptional.of(() -> new OutputStackHandler(this.inventory, arr));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.handler.cast() : super.getCapability(cap, side);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void update() {
        this.requestModelDataUpdate();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    private BaseStackHandler createInventory() {
        return new BaseStackHandler(this.size){

            protected void onContentsChanged(int slot) {
                InventoryBlockEntity.this.update();
                super.onContentsChanged(slot);
            }
        };
    }
}

