/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.forge.block.entity;

import jp.artan.dmlreloaded.config.EnergyCostConfig;
import jp.artan.dmlreloaded.forge.block.energy.DeepEnergyStorage;
import jp.artan.dmlreloaded.forge.block.entity.InventoryBlockEntity;
import jp.artan.dmlreloaded.forge.init.DMLBlockEntityForge;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class BlockEntityExtractionChamber
extends InventoryBlockEntity {
    public DeepEnergyStorage energyStorage;
    public boolean isCrafting = false;
    private LazyOptional<DeepEnergyStorage> energy;
    public int ticks = 0;
    public int percentDone = 0;
    private String currentPristineMatter = "";
    private ItemStack resultingItem = ItemStack.f_41583_;
    private int resultingIndex;
    private boolean selected;
    public int energyCost = (Integer)EnergyCostConfig.efCostExtractionChamber.get();
    private static Integer[] bannSlot = new Integer[]{0};

    public BlockEntityExtractionChamber(BlockPos pos, BlockState state) {
        super((BlockEntityType)DMLBlockEntityForge.ENTITY_EXTRACTION_CHAMBER.get(), pos, state, 17, bannSlot);
        this.energyStorage = this.createEnergyStorage();
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    private DeepEnergyStorage createEnergyStorage() {
        return new DeepEnergyStorage(this, 1000000, 25600, 0, 0);
    }

    public ItemStack getPristine() {
        return this.inventory.getStackInSlot(0);
    }

    public int getProgress() {
        return this.percentDone;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public boolean pristineChanged() {
        return !this.getPristine().m_41619_() && !this.currentPristineMatter.equals(((ItemPristineMatter)this.getPristine().m_41720_()).getMobKey().getId());
    }

    private boolean canStartCraft() {
        return this.canContinueCraft() && this.canInsertItem();
    }

    private boolean canContinueCraft() {
        return !this.resultingItem.m_41619_() && this.getPristine().m_41720_() instanceof ItemPristineMatter && this.hasEnergyForNextTick();
    }

    private boolean canInsertItem() {
        return this.inventory.canInsertItem(this.resultingItem);
    }

    private boolean hasEnergyForNextTick() {
        return this.energyStorage.getEnergyStored() >= this.energyCost;
    }

    public void tick(Level pLevel, BlockEntityExtractionChamber be) {
        ++this.ticks;
        if (this.getPristine().m_41619_()) {
            this.selected = false;
            this.setResultingItem(ItemStack.f_41583_);
        }
        if (!pLevel.f_46443_) {
            if (this.pristineChanged()) {
                this.finishCraft(true);
                this.selected = false;
                this.currentPristineMatter = ((ItemPristineMatter)this.getPristine().m_41720_()).getMobKey().getId();
                this.setResultingItem(ItemStack.f_41583_);
                this.update();
                return;
            }
            if (!this.isCrafting) {
                if (this.canStartCraft()) {
                    this.isCrafting = true;
                }
            } else {
                if (!this.canContinueCraft()) {
                    this.finishCraft(true);
                    return;
                }
                if (this.hasEnergyForNextTick()) {
                    this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - this.energyCost);
                    ++this.percentDone;
                }
                if (this.ticks % 300 == 0) {
                    this.update();
                }
                if (this.percentDone == 50) {
                    this.finishCraft(false);
                }
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setResultingItem(ItemStack stack) {
        this.resultingItem = stack;
    }

    public void setResultingIndex(int i) {
        this.resultingIndex = i;
    }

    public int getResultingIndex() {
        return this.resultingIndex;
    }

    public void finishCraft(boolean abort) {
        this.isCrafting = false;
        this.percentDone = 0;
        if (!abort) {
            ItemStack remainder = this.inventory.setInFirstAvailableSlot(this.resultingItem);
            while (!remainder.m_41619_()) {
                remainder = this.inventory.setInFirstAvailableSlot(remainder);
            }
            this.getPristine().m_41774_(1);
        }
        this.m_6596_();
        this.update();
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        tag.m_128405_("craftingProgress", this.percentDone);
        tag.m_128405_("index", this.resultingIndex);
        tag.m_128365_("resultingItem", (Tag)this.resultingItem.serializeNBT());
        tag.m_128379_("isCrafting", this.isCrafting);
        tag.m_128379_("selected", this.selected);
        tag.m_128359_("currentPristine", this.currentPristineMatter);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyStorage.setEnergy(pTag.m_128451_("energy"));
        this.percentDone = pTag.m_128451_("craftingProgress");
        this.resultingIndex = pTag.m_128451_("index");
        this.isCrafting = pTag.m_128471_("isCrafting");
        this.selected = pTag.m_128471_("selected");
        this.resultingItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("resultingItem"));
        this.currentPristineMatter = pTag.m_128441_("currentPristine") ? pTag.m_128461_("currentPristine") : "";
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ENERGY ? this.energy.cast() : super.getCapability(cap, side);
    }
}

