/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.events;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.concurrent.ThreadLocalRandom;
import jp.artan.dmlreloaded.DeepMobLearningReloadedMod;
import jp.artan.dmlreloaded.init.DMLItems;
import jp.artan.dmlreloaded.item.ItemGlitchArmor;
import jp.artan.dmlreloaded.item.ItemGlitchHeart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PlayerHandler {
    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(PlayerHandler::playerLogIn);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(PlayerHandler::playerRightClickedBlock);
        InteractionEvent.LEFT_CLICK_BLOCK.register(PlayerHandler::playerLeftClickedBlock);
    }

    private static void playerLogIn(ServerPlayer player) {
        Abilities cap = player.m_150110_();
        boolean isMayFly = cap.f_35936_;
        boolean isFlyEnabledAndFullSet = ItemGlitchArmor.isFlyEnabledAndFullSet(player);
        boolean isSpectator = player.m_5833_();
        boolean isCreative = player.m_7500_();
        if (!isMayFly && isFlyEnabledAndFullSet) {
            cap.f_35936_ = true;
            player.m_6885_();
        }
        if (!isFlyEnabledAndFullSet && isMayFly && !isSpectator && !isCreative) {
            cap.f_35936_ = false;
            cap.f_35935_ = false;
            player.m_6885_();
        }
    }

    private static EventResult playerRightClickedBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        if (!player.m_6047_()) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41720_() instanceof ItemGlitchHeart && rand.nextInt(0, 10) <= 3 && player.m_9236_().m_8055_(blockPos).m_60734_() == Blocks.f_50080_) {
                if (!player.m_9236_().f_46443_) {
                    double dropX = (double)blockPos.m_123341_() + 0.5 + (double)face.m_122429_();
                    double dropY = (double)blockPos.m_123342_() + 0.5 + (double)face.m_122430_();
                    double dropZ = (double)blockPos.m_123343_() + 0.5 + (double)face.m_122431_();
                    ItemEntity drop = new ItemEntity(player.m_9236_(), dropX, dropY, dropZ, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(DeepMobLearningReloadedMod.getResource("glitch_fragment")), 3), rand.nextDouble(-0.25, 0.25), rand.nextDouble(-0.25, 0.25), rand.nextDouble(-0.25, 0.25));
                    drop.m_32060_();
                    player.m_9236_().m_7967_((Entity)drop);
                    itemStack.m_41774_(1);
                }
                player.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12651_, SoundSource.NEUTRAL, 1.0f, 1.1f);
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, 0.0, 0.03, 0.0);
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    private static EventResult playerLeftClickedBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        if (!player.m_6047_()) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41720_() == Items.f_42451_ && rand.nextInt(0, 10) <= 3 && player.m_9236_().m_8055_(blockPos).m_60734_() == Blocks.f_50353_) {
                if (!player.m_9236_().f_46443_) {
                    double dropX = (double)blockPos.m_123341_() + 0.5 + (double)face.m_122429_();
                    double dropY = (double)blockPos.m_123342_() + 0.5 + (double)face.m_122430_();
                    double dropZ = (double)blockPos.m_123343_() + 0.5 + (double)face.m_122431_();
                    ItemEntity drop = new ItemEntity(player.m_9236_(), dropX, dropY, dropZ, new ItemStack((ItemLike)DMLItems.SOOT_COVERED_REDSTONE.get(), 1), rand.nextDouble(-0.25, 0.25), rand.nextDouble(-0.25, 0.25), rand.nextDouble(-0.25, 0.25));
                    drop.m_32060_();
                    player.m_9236_().m_7967_((Entity)drop);
                    itemStack.m_41774_(1);
                }
                player.m_9236_().m_5594_(null, blockPos, SoundEvents.f_144050_, SoundSource.NEUTRAL, 1.0f, 0.1f);
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() + rand.nextDouble(0.0, 1.0), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + rand.nextDouble(0.0, 1.0), 0.0, 0.03, 0.0);
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }
}

