/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.common.mobmetas;

import jp.artan.dmlreloaded.common.ILivingMatterType;
import jp.artan.dmlreloaded.common.IMobKey;
import jp.artan.dmlreloaded.item.ItemLivingMatter;
import jp.artan.dmlreloaded.item.ItemPristineMatter;
import jp.artan.dmlreloaded.util.RenderInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class MobMetaData {
    protected String entityId;
    protected IMobKey key;
    protected int numberOfHearts;
    protected int simulationTickCost;
    protected ItemPristineMatter pristineMatter;
    @Nullable
    protected Item spawnEggItem;
    protected int mobTriviaLine;

    public MobMetaData(IMobKey key, String entityId, int simulationTickCost, int numberOfHearts, ItemPristineMatter pristineMatter, @Nullable Item spawnEggItem) {
        this(key, entityId, simulationTickCost, numberOfHearts, pristineMatter, spawnEggItem, 0);
    }

    public MobMetaData(IMobKey key, String entityId, int simulationTickCost, int numberOfHearts, ItemPristineMatter pristineMatter, @Nullable Item spawnEggItem, int mobTriviaLine) {
        this.key = key;
        this.entityId = entityId;
        this.simulationTickCost = simulationTickCost;
        this.numberOfHearts = numberOfHearts;
        this.pristineMatter = pristineMatter;
        this.spawnEggItem = spawnEggItem;
        this.mobTriviaLine = mobTriviaLine;
    }

    public int getSimulationTickCost() {
        return this.simulationTickCost;
    }

    public ItemStack getLivingMatterStack(int amount) {
        return new ItemStack((ItemLike)this.getLivingMatter(), amount);
    }

    public ItemStack getPristineMatterStack(int amount) {
        return new ItemStack((ItemLike)this.pristineMatter, amount);
    }

    public ItemStack getSpawnEgg() {
        if (this.spawnEggItem == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)this.spawnEggItem);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public IMobKey getKey() {
        return this.key;
    }

    public int getNumberOfHearts() {
        return this.numberOfHearts;
    }

    public ILivingMatterType getType() {
        return this.getKey().getLivingMatterType();
    }

    public ItemLivingMatter getLivingMatter() {
        return (ItemLivingMatter)((Object)this.getType().getLivingMatter().get());
    }

    public ItemPristineMatter getPristineMatter() {
        return this.pristineMatter;
    }

    public int getMobTriviaLine() {
        return this.mobTriviaLine;
    }

    public static String getMobTriviaLangId(IMobKey key, int index) {
        return "dmlreloaded.gui.mob." + key.getId() + ".trivia." + index;
    }

    public MutableComponent getMobTrivia(int index) {
        return Component.m_237115_((String)MobMetaData.getMobTriviaLangId(this.getKey(), index));
    }

    public boolean entityLivingMatchesMob(LivingEntity entity) {
        String name = entity.m_6095_().m_20675_();
        for (IMobKey.Mob mobRegname : this.getKey().getMobs()) {
            if (!mobRegname.getLangId().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getOffsetY(LivingEntity livingEntity) {
        return 0;
    }

    public RenderInfo transform(RenderInfo renderInfo, LivingEntity entity) {
        return renderInfo;
    }

    public abstract LivingEntity getEntity(Level var1);
}

