/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities.matrix;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.orientation.BlockOrientation;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.util.iterators.ChainedIterator;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.me.matrix.CalculatorAssemblerMatrix;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TileAssemblerMatrixBase
extends AENetworkBlockEntity
implements IAEMultiBlock<ClusterAssemblerMatrix>,
IPowerChannelState {
    protected final CalculatorAssemblerMatrix calc = new CalculatorAssemblerMatrix(this);
    protected boolean isCore = false;
    protected CompoundTag previousState = null;
    protected ClusterAssemblerMatrix cluster;

    public TileAssemblerMatrixBase(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL}).addService(IGridMultiblock.class, (IGridNodeService)((IGridMultiblock)this::getMultiblockNodes));
        this.getMainNode().setIdlePowerUsage(0.0);
    }

    public CompoundTag getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundTag previousState) {
        this.previousState = previousState;
    }

    public boolean isCore() {
        return this.isCore;
    }

    public void setCore(boolean core) {
        this.isCore = core;
    }

    protected Item getItemFromBlockEntity() {
        if (this.f_58857_ == null) {
            return Items.f_41852_;
        }
        return this.getMatrixBlock().getPresentItem();
    }

    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity());
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.f_58858_);
        }
    }

    public void updateMultiBlock(BlockPos changedPos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.f_58858_, changedPos);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            ArrayList<BlockPos> places = new ArrayList<BlockPos>();
            for (TileAssemblerMatrixBase blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.f_58858_);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = blockEntity.f_58858_.m_121945_(d);
                    if (!this.f_58857_.m_46859_(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            this.cluster.destroy();
        }
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.m_58900_().m_61143_((Property)BlockAssemblerMatrixBase.FORMED);
        }
        return this.cluster != null;
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("core", this.isCore);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.setCore(data.m_128471_("core"));
        if (this.isCore) {
            this.setPreviousState(data.m_6426_());
        }
    }

    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    public ClusterAssemblerMatrix getCluster() {
        return this.cluster;
    }

    public boolean isValid() {
        return true;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.requestModelDataUpdate();
    }

    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public void updateStatus(ClusterAssemblerMatrix c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        BlockState newState;
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        BlockState current = this.f_58857_.m_8055_(this.f_58858_);
        if (current.m_60734_() instanceof BlockAssemblerMatrixBase && current != (newState = (BlockState)((BlockState)current.m_61124_((Property)BlockAssemblerMatrixBase.POWERED, (Comparable)Boolean.valueOf(power))).m_61124_((Property)BlockAssemblerMatrixBase.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.f_58857_.m_7731_(this.f_58858_, newState, 2);
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockAssemblerMatrixBase.POWERED);
        }
        return this.getMainNode().isActive();
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.noneOf(Direction.class);
    }

    public BlockAssemblerMatrixBase<?> getMatrixBlock() {
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return EPPItemAndBlock.ASSEMBLER_MATRIX_FRAME;
        }
        return (BlockAssemblerMatrixBase)this.f_58857_.m_8055_(this.f_58858_).m_60734_();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator((Object[])new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), IGridConnectedBlockEntity::getGridNode);
    }
}

