/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;

public abstract class Tab
extends CompositeWidgetBase<WidgetBase> {
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    public static final int DEFAULT_HEIGHT = 24;
    protected static final int DEFAULT_WIDTH = 21;
    private int width = 21;
    private int height = 24;
    private final List<Component> tooltip;
    private BooleanSupplier shouldShowTooltip = () -> true;
    protected BooleanSupplier shouldRender = () -> true;

    protected Tab(Position position, List<Component> tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position, new Dimension(0, 0));
        this.tooltip = tooltip;
        this.addChild(getTabButton.apply(this::onTabIconClicked));
    }

    protected Tab(Position position, Component tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        this(position, List.of(tooltip), getTabButton);
    }

    public void setHandlers(BooleanSupplier shouldShowTooltip, BooleanSupplier shouldRender) {
        this.shouldShowTooltip = shouldShowTooltip;
        this.shouldRender = shouldRender;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.getAsBoolean()) {
            return;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        if (this.shouldRender.getAsBoolean() && this.isClosedTooltipVisible(mouseX, mouseY)) {
            guiGraphics.m_280677_(screen.f_96547_, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Optional<Rect2i> getTabRectangle() {
        return GuiHelper.getPositiveRectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        int halfHeight = this.height / 2;
        guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.x, this.y, 256.0f - (float)this.width, 0.0f, this.width, halfHeight, 256, 256);
        guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.x, this.y + halfHeight, 256.0f - (float)this.width, 256.0f - (float)halfHeight, this.width, halfHeight, 256, 256);
        guiGraphics.m_280218_(GuiHelper.GUI_CONTROLS, this.x - 3, this.y, 128, 256 - this.height, 3, this.height);
    }

    protected boolean isClosedTooltipVisible(int mouseX, int mouseY) {
        return this.shouldShowTooltip.getAsBoolean() && this.m_5953_(mouseX, mouseY);
    }

    public int getTopY() {
        return this.y;
    }

    public int getBottomY() {
        return this.y + this.getHeight();
    }

    protected abstract void onTabIconClicked(int var1);

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    @Override
    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

