/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    static void handle(TeleportRequest message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            double toZ;
            double toX;
            float pitch;
            Level patt1711$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (TeleportHandler.isBadTeleportPacket(message, player)) {
                return;
            }
            if (((Boolean)ModConfig.GENERAL.useXP.get()).booleanValue() && !player.m_7500_()) {
                Integer xpCost = (Integer)ModConfig.GENERAL.XPPointsAmount.get();
                if (TeleportHandler.getPlayerExperienceProgress((Player)player) - xpCost >= 0 || player.f_36078_ > 0) {
                    player.m_6756_(-xpCost.intValue());
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"elevatorid.message.missing_xp").m_130940_(ChatFormatting.RED), true);
                    return;
                }
            }
            if (!((patt1711$temp = player.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel world = (ServerLevel)patt1711$temp;
            BlockPos toPos = message.getTo();
            BlockState toState = world.m_8055_(message.getTo());
            float yaw = (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) != false ? ((Direction)toState.m_61143_((Property)ElevatorBlock.f_54117_)).m_122435_() : player.m_146908_();
            float f = pitch = (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) != false && (Boolean)ModConfig.GENERAL.resetPitchDirectional.get() != false || (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) == false && (Boolean)ModConfig.GENERAL.resetPitchNormal.get() != false ? 0.0f : player.m_146909_();
            if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
                toX = (double)toPos.m_123341_() + 0.5;
                toZ = (double)toPos.m_123343_() + 0.5;
            } else {
                toX = player.m_20185_();
                toZ = player.m_20189_();
            }
            double blockYOffset = toState.m_60816_((BlockGetter)world, toPos).m_83297_(Direction.Axis.Y);
            player.m_8999_(world, toX, Math.max((double)toPos.m_123342_(), (double)toPos.m_123342_() + blockYOffset), toZ, yaw, pitch);
            player.m_20256_(player.m_20184_().m_82559_(new Vec3(1.0, 0.0, 1.0)));
            world.m_5594_(null, toPos, (SoundEvent)Registry.TELEPORT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean isBadTeleportPacket(TeleportRequest msg, ServerPlayer player) {
        if (player == null || !player.m_6084_()) {
            return true;
        }
        Level world = player.m_9236_();
        BlockPos fromPos = msg.getFrom();
        BlockPos toPos = msg.getTo();
        if (!world.m_46749_(fromPos) || !world.m_46749_(toPos)) {
            return true;
        }
        double distanceSq = player.m_20238_(Vec3.m_82512_((Vec3i)fromPos));
        if (distanceSq > 6.0) {
            return true;
        }
        if (fromPos.m_123341_() != toPos.m_123341_() || fromPos.m_123343_() != toPos.m_123343_()) {
            return true;
        }
        if (fromPos.m_123342_() == toPos.m_123342_()) {
            return true;
        }
        ElevatorBlock fromElevator = TeleportHandler.getElevator(world.m_8055_(fromPos));
        ElevatorBlock toElevator = TeleportHandler.getElevator(world.m_8055_(toPos));
        if (fromElevator == null || toElevator == null) {
            return true;
        }
        if (!TeleportHandler.isValidPos((BlockGetter)world, toPos)) {
            return true;
        }
        return (Boolean)ModConfig.GENERAL.sameColor.get() != false && fromElevator.getColor() != toElevator.getColor();
    }

    private static int getPlayerExperienceProgress(Player player) {
        return Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static boolean isValidPos(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos.m_7494_()).m_60812_(world, pos.m_7494_()).m_83281_();
    }

    public static ElevatorBlock getElevator(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof ElevatorBlock) {
            ElevatorBlock elevator = (ElevatorBlock)block;
            return elevator;
        }
        return null;
    }
}

