/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.framed;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramedControllerIO
extends BlockSlave
implements IFramedBlock {
    public BlockFramedControllerIO(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntitySlave blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntitySlave.class);
        if (blockEntity == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        blockEntity.material().read(tag);
        blockEntity.m_6596_();
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntitySlave)builder.m_287159_(LootContextParams.f_81462_)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntitySlave tile) {
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        CompoundTag data = drop.m_41784_();
        tile.material().write(data);
        drop.m_41751_(data);
        return drop;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntitySlave tile = WorldUtils.getBlockEntity(level, pos, BlockEntitySlave.class);
        if (tile != null && !tile.material().isEmpty()) {
            CompoundTag data = stack.m_41784_();
            tile.material().write(data);
            stack.m_41751_(data);
        }
        return stack;
    }

    @Override
    public IFramedBlockEntity getFramedBlockEntity(@NotNull Level world, @NotNull BlockPos pos) {
        return WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntitySlave.class);
    }

    @Override
    public boolean supportsFrameMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new IncompatibleClassChangeError();
            case FrameMaterial.SIDE, FrameMaterial.TRIM -> true;
            case FrameMaterial.FRONT -> false;
        };
    }
}

