/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server_bound;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.controls.ScreenControlRegistry;
import net.montoyo.wd.controls.builtin.AutoVolumeControl;
import net.montoyo.wd.controls.builtin.JSRequestControl;
import net.montoyo.wd.controls.builtin.KeyTypedControl;
import net.montoyo.wd.controls.builtin.LaserControl;
import net.montoyo.wd.controls.builtin.ManageRightsAndUpdgradesControl;
import net.montoyo.wd.controls.builtin.ModifyFriendListControl;
import net.montoyo.wd.controls.builtin.ScreenModifyControl;
import net.montoyo.wd.controls.builtin.SetURLControl;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.net.BufferUtils;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.data.Rotation;
import net.montoyo.wd.utilities.math.Vector2i;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public class C2SMessageScreenCtrl
extends Packet {
    @Deprecated(forRemoval=true)
    public static final int CTRL_LASER_MOVE = 0;
    @Deprecated(forRemoval=true)
    public static final int CTRL_LASER_UP = 0;
    @Deprecated(forRemoval=true)
    public static final int CTRL_LASER_DOWN = 0;
    @Deprecated(forRemoval=true)
    public static final int CTRL_SET_RESOLUTION = 0;
    ScreenControl control;
    BlockPos pos;
    BlockSide side;

    public C2SMessageScreenCtrl() {
    }

    public C2SMessageScreenCtrl(ScreenBlockEntity screen, BlockSide side, ScreenControl control) {
        this.pos = screen.m_58899_();
        this.side = side;
        this.control = control;
    }

    protected static C2SMessageScreenCtrl base(ScreenBlockEntity screen, BlockSide side) {
        C2SMessageScreenCtrl packet = new C2SMessageScreenCtrl();
        packet.pos = screen.m_58899_();
        packet.side = side;
        return packet;
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl setURL(ScreenBlockEntity tes, BlockSide side, String url, Vector3i remoteLocation) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new SetURLControl(url, remoteLocation);
        return ret;
    }

    @Deprecated(forRemoval=true)
    public C2SMessageScreenCtrl(ScreenBlockEntity tes, BlockSide side, NameUUIDPair friend, boolean del) {
        this(tes, side, new ModifyFriendListControl(friend, !del));
    }

    @Deprecated(forRemoval=true)
    public C2SMessageScreenCtrl(ScreenBlockEntity tes, BlockSide side, int fr, int or) {
        this(tes, side, new ManageRightsAndUpdgradesControl(fr, or));
    }

    @Deprecated(forRemoval=true)
    public C2SMessageScreenCtrl(ScreenBlockEntity tes, BlockSide side, ItemStack toRem) {
        this(tes, side, new ManageRightsAndUpdgradesControl(false, toRem));
    }

    @Deprecated(forRemoval=true)
    public C2SMessageScreenCtrl(ScreenBlockEntity tes, BlockSide side, Rotation rot) {
        this(tes, side, new ScreenModifyControl(rot));
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl vec2(ScreenBlockEntity tes, BlockSide side, int ctrl, Vector2i vec) {
        throw new RuntimeException("Moved: look into ScreenControlRegistry");
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl resolution(ScreenBlockEntity tes, BlockSide side, Vector2i vec) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new ScreenModifyControl(vec);
        return ret;
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl type(ScreenBlockEntity tes, BlockSide side, String text, BlockPos soundPos) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new KeyTypedControl(text, soundPos);
        return ret;
    }

    public static C2SMessageScreenCtrl laserMove(ScreenBlockEntity tes, BlockSide side, Vector2i vec) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new LaserControl(LaserControl.ControlType.MOVE, vec);
        return ret;
    }

    public static C2SMessageScreenCtrl laserDown(ScreenBlockEntity tes, BlockSide side, Vector2i vec, int button) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new LaserControl(LaserControl.ControlType.DOWN, vec, button);
        return ret;
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl laserUp(ScreenBlockEntity tes, BlockSide side, int button) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new LaserControl(LaserControl.ControlType.UP, null, button);
        return ret;
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl jsRequest(ScreenBlockEntity tes, BlockSide side, int reqId, JSServerRequest reqType, Object ... data) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new JSRequestControl(reqId, reqType, data);
        return ret;
    }

    @Deprecated(forRemoval=true)
    public static C2SMessageScreenCtrl autoVol(ScreenBlockEntity tes, BlockSide side, boolean av) {
        C2SMessageScreenCtrl ret = C2SMessageScreenCtrl.base(tes, side);
        ret.control = new AutoVolumeControl(av);
        return ret;
    }

    public C2SMessageScreenCtrl(FriendlyByteBuf buf) {
        super(buf);
        this.pos = buf.m_130135_();
        this.side = (BlockSide)BufferUtils.readEnum(buf, i -> BlockSide.values()[i], (byte)1);
        this.control = ScreenControlRegistry.parse(buf);
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        BufferUtils.writeEnum(buf, this.side, (byte)1);
        buf.m_130070_(this.control.getId().toString());
        this.control.write(buf);
    }

    public void checkPermission(ServerPlayer sender, ScreenBlockEntity scr, int right) throws MissingPermissionException {
        int prights = scr.getScreen(this.side).rightsFor((Player)sender);
        if ((prights & right) == 0) {
            throw new MissingPermissionException(right, sender);
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkServer(ctx)) {
            ctx.enqueueWork(() -> {
                try {
                    Level level = (Level)WebDisplays.PROXY.getWorld(ctx);
                    BlockEntity be = level.m_7702_(this.pos);
                    if (be instanceof ScreenBlockEntity) {
                        ScreenBlockEntity tes = (ScreenBlockEntity)be;
                        this.control.handleServer(this.pos, this.side, tes, ctx, perm -> {
                            try {
                                this.checkPermission(ctx.getSender(), tes, (int)perm);
                                return true;
                            }
                            catch (Throwable ignored) {
                                return false;
                            }
                        });
                    }
                }
                catch (MissingPermissionException e) {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

