/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client_bound;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.controls.ScreenControlRegistry;
import net.montoyo.wd.controls.builtin.AutoVolumeControl;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.controls.builtin.KeyTypedControl;
import net.montoyo.wd.controls.builtin.ManageRightsAndUpdgradesControl;
import net.montoyo.wd.controls.builtin.OwnerControl;
import net.montoyo.wd.controls.builtin.ScreenModifyControl;
import net.montoyo.wd.controls.builtin.SetURLControl;
import net.montoyo.wd.controls.builtin.TurnOffControl;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.net.BufferUtils;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.data.Rotation;
import net.montoyo.wd.utilities.math.Vector2i;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public class S2CMessageScreenUpdate
extends Packet {
    ScreenControl control;
    BlockPos pos;
    BlockSide side;

    public S2CMessageScreenUpdate(BlockPos blockPos, BlockSide side) {
        this.pos = blockPos;
        this.side = side;
    }

    public S2CMessageScreenUpdate(FriendlyByteBuf buf) {
        super(buf);
        this.pos = buf.m_130135_();
        this.side = (BlockSide)BufferUtils.readEnum(buf, i -> BlockSide.values()[i], (byte)1);
        this.control = ScreenControlRegistry.parse(buf);
    }

    public static S2CMessageScreenUpdate setURL(ScreenBlockEntity screen, BlockSide side, String weburl) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new SetURLControl(weburl, new Vector3i(screenUpdate.pos));
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate setResolution(ScreenBlockEntity screen, BlockSide side, Vector2i res) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new ScreenModifyControl(res);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate rotation(ScreenBlockEntity screen, BlockSide side, Rotation rot) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new ScreenModifyControl(rot);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate upgrade(ScreenBlockEntity screen, BlockSide side, boolean adding, ItemStack stack) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new ManageRightsAndUpdgradesControl(adding, stack);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate click(ScreenBlockEntity screen, BlockSide side, ClickControl.ControlType mouseMove, Vector2i pos) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new ClickControl(mouseMove, pos);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate type(ScreenBlockEntity screen, BlockSide side, String text) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new KeyTypedControl(text, screenUpdate.pos);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate autoVolume(ScreenBlockEntity screen, BlockSide side, boolean av) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new AutoVolumeControl(av);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate owner(ScreenBlockEntity screen, BlockSide side, NameUUIDPair owner) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(screen.m_58899_(), side);
        screenUpdate.control = new OwnerControl(owner);
        return screenUpdate;
    }

    public static S2CMessageScreenUpdate turnOff(BlockPos blockPos, BlockSide side) {
        S2CMessageScreenUpdate screenUpdate = new S2CMessageScreenUpdate(blockPos, side);
        screenUpdate.control = TurnOffControl.INSTANCE;
        return screenUpdate;
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        BufferUtils.writeEnum(buf, this.side, (byte)1);
        buf.m_130070_(this.control.getId().toString());
        this.control.write(buf);
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkClient(ctx)) {
            ctx.enqueueWork(() -> {
                Level level = (Level)WebDisplays.PROXY.getWorld(ctx);
                BlockEntity be = level.m_7702_(this.pos);
                if (be instanceof ScreenBlockEntity) {
                    ScreenBlockEntity tes = (ScreenBlockEntity)be;
                    this.control.handleClient(this.pos, this.side, tes, ctx);
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

