/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import net.montoyo.wd.miniserv.AbstractClient;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketHandler;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.server.Server;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.serialization.Util;

public class ServerClient
extends AbstractClient {
    private static final byte[] FILE_UPLOAD_BUFFER = new byte[65535];
    private boolean remove;
    private boolean isAuthenticated;
    private UUID uuid;
    private byte[] challenge;
    private File userDir;
    private long quota;
    private FileOutputStream currentFile;
    private long currentFileSize;
    private long currentFileExpectedSize;
    private boolean sendingFile;
    private long lastDataTime;

    ServerClient(SocketChannel s, Selector ss) {
        this.socket = s;
        this.selector = ss;
        try {
            this.selKey = this.socket.register(this.selector, 1);
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
        this.lastDataTime = System.currentTimeMillis();
    }

    @Override
    protected void onWriteError() {
        this.remove = true;
    }

    void setShouldRemove() {
        this.remove = true;
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public boolean hasTimedOut(long now) {
        return now - this.lastDataTime >= 30000L;
    }

    SocketChannel getChannel() {
        return this.socket;
    }

    @PacketHandler(value=PacketID.INIT_CONN)
    public void handleInitConnPacket(DataInputStream dis) throws IOException {
        if (this.uuid != null) {
            Log.warning("A client tried to change his UUID?", new Object[0]);
            return;
        }
        long msb = dis.readLong();
        long lsb = dis.readLong();
        UUID uuid = new UUID(msb, lsb);
        byte[] key = Server.getInstance().getClientManager().getClientKey(uuid);
        if (key == null) {
            Log.warning("Unkown client with UUID %s wanted to connect", uuid.toString());
            this.remove = true;
        } else {
            this.uuid = uuid;
            this.challenge = Server.getInstance().getClientManager().generateChallenge();
            OutgoingPacket pkt = new OutgoingPacket();
            pkt.writeByte(PacketID.AUTHENTICATE.ordinal());
            pkt.writeByte(this.challenge.length);
            pkt.writeBytes(this.challenge);
            this.sendPacket(pkt);
        }
    }

    @PacketHandler(value=PacketID.AUTHENTICATE)
    public void handleAuthPacket(DataInputStream dis) throws IOException {
        if (this.uuid == null) {
            Log.warning("A client tried to authenticate, but he didn't send the connection packet", new Object[0]);
            this.remove = true;
            return;
        }
        int len = dis.readByte() & 0xFF;
        byte[] mac = new byte[len];
        dis.readFully(mac);
        if (Server.getInstance().getClientManager().verifyClient(this.uuid, this.challenge, mac)) {
            Log.info("Client with UUID %s authenticated successfully", this.uuid.toString());
            this.userDir = new File(Server.getInstance().getDirectory(), this.uuid.toString());
            if (!this.userDir.exists() && !this.userDir.mkdir()) {
                Log.warning("Could not create storage directory for user %s, things may go wrong...", this.uuid.toString());
            }
            try {
                DataInputStream quotaDis = new DataInputStream(new FileInputStream(new File(this.userDir, ".quota")));
                this.quota = quotaDis.readLong();
                Util.silentClose(quotaDis);
            }
            catch (FileNotFoundException ex) {
                this.quota = 0L;
            }
            catch (IOException ex) {
                Log.warningEx("Couldn't read quota for user %s, things may go wrong...", ex, this.uuid.toString());
                this.quota = Server.getInstance().getMaxQuota();
            }
            this.isAuthenticated = true;
        } else {
            Log.warning("Client with UUID %s failed to authenticate", this.uuid.toString());
            this.remove = true;
        }
    }

    @PacketHandler(value=PacketID.PING)
    public void handlePing(DataInputStream dis) {
        if (this.isAuthenticated) {
            OutgoingPacket pkt = new OutgoingPacket();
            pkt.writeByte(PacketID.PING.ordinal());
            this.sendPacket(pkt);
        }
    }

    @PacketHandler(value=PacketID.BEGIN_FILE_UPLOAD)
    public void handleBeginUpload(DataInputStream dis) throws IOException {
        if (this.isAuthenticated) {
            String fname = ServerClient.readString(dis);
            long size = dis.readLong();
            OutgoingPacket rep = new OutgoingPacket();
            rep.writeByte(PacketID.BEGIN_FILE_UPLOAD.ordinal());
            if (Util.isFileNameInvalid(fname)) {
                Log.warning("Client %s tried to upload a file with a bad name", this.uuid.toString());
                rep.writeByte(1);
            } else if (size <= 0L) {
                Log.warning("Client %s tried to upload a file an invalid size", this.uuid.toString());
                rep.writeByte(2);
            } else if (this.quota + size > Server.getInstance().getMaxQuota()) {
                rep.writeByte(3);
            } else if (this.currentFile != null || this.sendingFile) {
                rep.writeByte(4);
            } else {
                File fle = new File(this.userDir, fname);
                if (fle.exists()) {
                    rep.writeByte(5);
                } else {
                    try {
                        this.currentFile = new FileOutputStream(fle);
                        this.currentFileSize = 0L;
                        this.currentFileExpectedSize = size;
                        rep.writeByte(0);
                    }
                    catch (IOException ex) {
                        Log.warningEx("IOException while uploading file %s from user %s", ex, fname, this.uuid.toString());
                        rep.writeByte(6);
                    }
                }
            }
            this.sendPacket(rep);
        }
    }

    @PacketHandler(value=PacketID.FILE_PART)
    public void handleFilePart(DataInputStream dis) throws IOException {
        if (this.isAuthenticated && this.currentFile != null) {
            int len = dis.readShort() & 0xFFFF;
            if (len <= 0) {
                this.finishUpload(7);
                return;
            }
            this.currentFileSize += (long)len;
            if (this.currentFileSize > this.currentFileExpectedSize) {
                this.finishUpload(8);
                return;
            }
            try {
                this.currentFile.write(this.getCurrentPacketRawData(), 3, len);
            }
            catch (IOException ex) {
                Log.warningEx("Client %s encountered an IOException while uploading some file", ex, this.uuid.toString());
                this.finishUpload(6);
                this.currentFileSize -= (long)len;
                return;
            }
            if (this.currentFileSize >= this.currentFileExpectedSize) {
                this.finishUpload(0);
            }
        }
    }

    @PacketHandler(value=PacketID.GET_FILE)
    public void handleGetFile(DataInputStream dis) throws IOException {
        if (this.isAuthenticated && this.currentFile == null) {
            long msb = dis.readLong();
            long lsb = dis.readLong();
            String fname = ServerClient.readString(dis);
            boolean doQuery = dis.readBoolean();
            OutgoingPacket rep = new OutgoingPacket();
            rep.writeByte(PacketID.GET_FILE.ordinal());
            if (Util.isFileNameInvalid(fname)) {
                rep.writeByte(1);
            } else {
                UUID user = new UUID(msb, lsb);
                File fle = new File(Server.getInstance().getDirectory(), user.toString() + File.separatorChar + fname);
                if (doQuery) {
                    try {
                        rep.setOnFinishAction(new SendFileCallback(fle));
                        rep.writeByte(0);
                        this.sendingFile = true;
                    }
                    catch (FileNotFoundException ex) {
                        rep.writeByte(2);
                    }
                } else {
                    rep.writeByte(fle.exists() && fle.isFile() ? 0 : 2);
                }
            }
            this.sendPacket(rep);
        }
    }

    @PacketHandler(value=PacketID.QUOTA)
    public void handleQuota(DataInputStream dis) {
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.QUOTA.ordinal());
        pkt.writeLong(this.quota);
        pkt.writeLong(Server.getInstance().getMaxQuota());
        this.sendPacket(pkt);
    }

    @PacketHandler(value=PacketID.LIST)
    public void handleList(DataInputStream dis) throws IOException {
        File[] files;
        long msb = dis.readLong();
        long lsb = dis.readLong();
        File dir = new File(Server.getInstance().getDirectory(), new UUID(msb, lsb).toString());
        String[] list = null;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            list = (String[])Arrays.stream(files).filter(f -> f.isFile() && !Util.isFileNameInvalid(f.getName())).map(File::getName).toArray(String[]::new);
        }
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.LIST.ordinal());
        if (list == null) {
            pkt.writeByte(0);
        } else {
            pkt.writeByte(list.length);
            Arrays.stream(list).forEach(pkt::writeString);
        }
        this.sendPacket(pkt);
    }

    @PacketHandler(value=PacketID.DELETE)
    public void handleDelete(DataInputStream dis) throws IOException {
        String fname = ServerClient.readString(dis);
        int status = 2;
        if (!Util.isFileNameInvalid(fname)) {
            File file = new File(this.userDir, fname);
            if (file.exists() && file.isFile()) {
                try {
                    long sz = Files.size(file.toPath());
                    if (file.delete()) {
                        this.quota -= sz;
                        if (this.quota < 0L) {
                            this.quota = 0L;
                        }
                        this.saveQuota();
                        status = 0;
                    }
                }
                catch (IOException ex) {
                    Log.errorEx("Couldn't get size of file %s of user %s for removal", ex, file.getAbsolutePath(), this.uuid.toString());
                }
            } else {
                status = 1;
            }
        }
        OutgoingPacket ret = new OutgoingPacket();
        ret.writeByte(PacketID.DELETE.ordinal());
        ret.writeByte(status);
        this.sendPacket(ret);
    }

    private void finishUpload(int status) {
        if (this.currentFile != null) {
            OutgoingPacket pkt = new OutgoingPacket();
            pkt.writeByte(PacketID.FILE_STATUS.ordinal());
            pkt.writeByte(status);
            this.sendPacket(pkt);
            Util.silentClose(this.currentFile);
            this.currentFile = null;
            this.quota += this.currentFileSize;
            this.saveQuota();
        }
    }

    private void saveQuota() {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(this.userDir, ".quota")));
            dos.writeLong(this.quota);
            Util.silentClose(dos);
        }
        catch (IOException ex) {
            Log.errorEx("Could not save quota data for user %s", ex, this.uuid.toString());
        }
    }

    @Override
    protected void onDataReceived() {
        this.lastDataTime = System.currentTimeMillis();
    }

    public String getUUIDString() {
        return this.uuid == null ? "[NOT IDENTIFIED YET]" : this.uuid.toString();
    }

    private class SendFileCallback
    implements Consumer<OutgoingPacket> {
        private final FileInputStream fis;

        private SendFileCallback(File fle) throws FileNotFoundException {
            this.fis = new FileInputStream(fle);
        }

        @Override
        public void accept(OutgoingPacket nocare) {
            int rd;
            do {
                try {
                    rd = this.fis.read(FILE_UPLOAD_BUFFER);
                }
                catch (IOException ex) {
                    Log.warningEx("Caught IOException while sending some file", ex, new Object[0]);
                    OutgoingPacket pkt = new OutgoingPacket();
                    pkt.writeByte(PacketID.GET_FILE.ordinal());
                    pkt.writeByte(3);
                    ServerClient.this.sendPacket(pkt);
                    Util.silentClose(this.fis);
                    ServerClient.this.sendingFile = false;
                    return;
                }
            } while (rd == 0);
            OutgoingPacket pkt = new OutgoingPacket();
            if (rd < 0) {
                rd = 0;
                ServerClient.this.sendingFile = false;
            } else {
                pkt.setOnFinishAction(this);
            }
            pkt.writeByte(PacketID.FILE_PART.ordinal());
            pkt.writeShort(rd);
            pkt.writeBytes(FILE_UPLOAD_BUFFER, 0, rd);
            ServerClient.this.sendPacket(pkt);
        }
    }
}

