/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.function.Consumer;

public final class OutgoingPacket {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private DataOutputStream dos = new DataOutputStream(this.baos);
    private Consumer<OutgoingPacket> onFinish;

    public final void writeLong(long l) {
        try {
            this.dos.writeLong(l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeInt(int i) {
        try {
            this.dos.writeInt(i);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeByte(int b) {
        try {
            this.dos.writeByte(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeShort(int s) {
        try {
            this.dos.writeShort(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeBoolean(boolean b) {
        try {
            this.dos.writeBoolean(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeBytes(byte[] data) {
        try {
            this.dos.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeBytes(byte[] data, int offset, int size) {
        try {
            this.dos.write(data, offset, size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeString(String str) {
        byte[] bytes;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return;
        }
        try {
            this.dos.writeShort(bytes.length);
            this.dos.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final int writeStream(InputStream is, int max) throws IOException {
        int origMax = max;
        byte[] buf = new byte[8192];
        while (max > 0) {
            int read = is.read(buf, 0, max < buf.length ? max : buf.length);
            if (read <= 0) {
                return origMax - max;
            }
            this.dos.write(buf, 0, read);
            max -= read;
        }
        return origMax;
    }

    public final byte[] finish() {
        if (this.onFinish != null) {
            this.onFinish.accept(this);
        }
        byte[] bytes = this.baos.toByteArray();
        this.baos = null;
        this.dos = null;
        return bytes;
    }

    public final void setOnFinishAction(Consumer<OutgoingPacket> action) {
        this.onFinish = action;
    }
}

