/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.core;

import java.util.Map;
import net.montoyo.wd.core.IComputerArgs;

public class CCArguments
implements IComputerArgs {
    private final Object[] args;

    public CCArguments(Object[] args) {
        this.args = args;
    }

    @Override
    public String checkString(int i) {
        this.checkIndex(i, "string");
        Object obj = this.args[i];
        if (!(obj instanceof String)) {
            throw CCArguments.typeError(i, "string", obj);
        }
        return (String)obj;
    }

    @Override
    public int checkInteger(int i) {
        int ret;
        this.checkIndex(i, "number");
        Object obj = this.args[i];
        if (obj instanceof Integer) {
            ret = (Integer)obj;
        } else if (obj instanceof Double) {
            ret = ((Double)obj).intValue();
        } else if (obj instanceof Float) {
            ret = ((Float)obj).intValue();
        } else {
            throw CCArguments.typeError(i, "number", obj);
        }
        return ret;
    }

    @Override
    public Map checkTable(int i) {
        this.checkIndex(i, "table");
        Object obj = this.args[i];
        if (!(obj instanceof Map)) {
            throw CCArguments.typeError(i, "table", this.args[i]);
        }
        return (Map)obj;
    }

    private void checkIndex(int idx, String want) {
        if (idx < 0 || idx >= this.args.length) {
            CCArguments.typeError(idx, want, null);
        }
    }

    private static IllegalArgumentException typeError(int idx, String want, Object got) {
        return new IllegalArgumentException("bad argument #" + (idx + 1) + " (" + want + " expected, got " + CCArguments.luaTypeName(got) + ")");
    }

    private static String luaTypeName(Object obj) {
        if (obj == null) {
            return "nil";
        }
        Class<?> cls = obj.getClass();
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return "boolean";
        }
        if (cls == Integer.class || cls == Integer.TYPE || cls == Double.class || cls == Double.TYPE || cls == Float.class || cls == Float.TYPE) {
            return "number";
        }
        if (cls == String.class) {
            return "string";
        }
        if (Map.class.isAssignableFrom(cls)) {
            return "table";
        }
        return cls.getSimpleName();
    }

    @Override
    public int count() {
        return this.args.length;
    }
}

