/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.config.annoconfg.handle;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.montoyo.wd.config.annoconfg.util.EnumType;
import sun.misc.Unsafe;

public class UnsafeHandle {
    private static final Unsafe theUnsafe;
    private final long offset;
    private final Consumer<Object> uploader;
    private final Supplier<Object> getter;

    public UnsafeHandle(Field f) {
        this(null, f);
    }

    public UnsafeHandle(Object relative, Field f) {
        this.offset = theUnsafe.staticFieldOffset(f);
        if (relative == null) {
            relative = theUnsafe.staticFieldBase(f);
        }
        Object finalRelative = relative;
        if (f.getType().isPrimitive()) {
            switch (EnumType.forClass(f.getType())) {
                case BYTE: {
                    this.uploader = v -> theUnsafe.putByte(finalRelative, this.offset, (Byte)v);
                    this.getter = () -> theUnsafe.getByte(finalRelative, this.offset);
                    break;
                }
                case SHORT: {
                    this.uploader = v -> theUnsafe.putShort(finalRelative, this.offset, (Short)v);
                    this.getter = () -> theUnsafe.getShort(finalRelative, this.offset);
                    break;
                }
                case INT: {
                    this.uploader = v -> theUnsafe.putInt(finalRelative, this.offset, (Integer)v);
                    this.getter = () -> theUnsafe.getInt(finalRelative, this.offset);
                    break;
                }
                case LONG: {
                    this.uploader = v -> theUnsafe.putLong(finalRelative, this.offset, (Long)v);
                    this.getter = () -> theUnsafe.getLong(finalRelative, this.offset);
                    break;
                }
                case FLOAT: {
                    this.uploader = v -> theUnsafe.putFloat(finalRelative, this.offset, ((Float)v).floatValue());
                    this.getter = () -> Float.valueOf(theUnsafe.getFloat(finalRelative, this.offset));
                    break;
                }
                case DOUBLE: {
                    this.uploader = v -> theUnsafe.putDouble(finalRelative, this.offset, (Double)v);
                    this.getter = () -> theUnsafe.getDouble(finalRelative, this.offset);
                    break;
                }
                case BOOLEAN: {
                    this.uploader = v -> theUnsafe.putBoolean(finalRelative, this.offset, (Boolean)v);
                    this.getter = () -> theUnsafe.getBoolean(finalRelative, this.offset);
                    break;
                }
                default: {
                    this.uploader = null;
                    this.getter = () -> null;
                    break;
                }
            }
        } else {
            this.uploader = v -> theUnsafe.putObject(finalRelative, this.offset, v);
            this.getter = () -> theUnsafe.getObject(finalRelative, this.offset);
        }
    }

    public void set(Object o) {
        this.uploader.accept(o);
    }

    public Object get() {
        return this.getter.get();
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = (Unsafe)f.get(null);
        }
        catch (Throwable ignored) {
            throw new RuntimeException("AnnoConfg: Failed to acquire an instance of the unsafe.");
        }
    }
}

