/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import org.lwjgl.glfw.GLFW;

public class TextField
extends Control {
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    public static final int DEFAULT_DISABLED_COLOR = 0x707070;
    private final EditBox field;
    private boolean enabled = true;
    private int textColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private final ArrayList<TextChangeListener> listeners = new ArrayList();

    public TextField() {
        this.field = new EditBox(this.font, 1, 1, 198, 20, Component.m_130674_((String)""));
        this.setFocused(false);
    }

    public TextField(int x, int y, int width, int height) {
        this.field = new EditBox(this.font, x + 1, y + 1, width - 2, height - 2, Component.m_130674_((String)""));
        this.setFocused(false);
    }

    public TextField(int x, int y, int width, int height, String text) {
        this.field = new EditBox(this.font, x + 1, y + 1, width - 2, height - 2, Component.m_130674_((String)""));
        this.field.m_94144_(text);
        this.setFocused(false);
    }

    private long mapScanCode(int key, char c) {
        if (key == 341 || key == 345) {
            return 29L;
        }
        return switch (key) {
            case 261 -> 83L;
            case 263 -> 75L;
            case 264 -> 80L;
            case 265 -> 72L;
            case 262 -> 77L;
            case 267 -> 81L;
            case 266 -> 73L;
            case 269 -> 79L;
            case 268 -> 71L;
            case 10, 257, 335 -> 28L;
            default -> GLFW.glfwGetKeyScancode((int)key);
        };
    }

    @Override
    public boolean keyDown(int key, int scanCode, int modifiers) {
        return this.field.m_7933_(key, scanCode, modifiers);
    }

    @Override
    public boolean keyUp(int key, int scanCode, int modifiers) {
        return this.field.m_7920_(key, scanCode, modifiers);
    }

    @Override
    public boolean keyTyped(int keyCode, int modifier) {
        if (keyCode == 257 || keyCode == 335) {
            parent.actionPerformed(new EnterPressedEvent(this));
        } else if (keyCode == 258) {
            parent.actionPerformed(new TabPressedEvent(this));
        } else {
            String old = this.enabled && this.field.m_93696_() ? this.field.m_94155_() : null;
            if (this.enabled && this.field.m_93696_() && !this.field.m_94155_().equals(old)) {
                for (TextChangeListener tcl : this.listeners) {
                    tcl.onTextChange(this, old, this.field.m_94155_());
                }
                parent.actionPerformed(new TextChangedEvent(this, old));
            }
            return this.field.m_5534_((char)keyCode, modifier);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.field.m_6375_(mouseX, mouseY, mouseButton)) {
            this.setFocused(true);
            return true;
        }
        return false;
    }

    @Override
    public void unfocus() {
        this.setFocused(false);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        return this.field.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public boolean mouseClickMove(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.field.m_6375_(mouseX, mouseY, 0);
    }

    @Override
    public boolean mouseMove(double mouseX, double mouseY) {
        this.field.m_94757_(mouseX, mouseY);
        return true;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double amount) {
        return this.field.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public void draw(GuiGraphics poseStack, int mouseX, int mouseY, float ptt) {
        this.field.m_88315_(poseStack, mouseX, mouseY, ptt);
    }

    public void setText(String text) {
        String old = this.field.m_94155_();
        this.field.m_94144_(text);
        if (!old.equals(text)) {
            for (TextChangeListener tcl : this.listeners) {
                tcl.onTextChange(this, old, text);
            }
        }
    }

    public void clear() {
        this.field.m_94144_("");
    }

    public String getText() {
        return this.field.m_94155_();
    }

    public String getSelectedText() {
        return this.field.m_94173_();
    }

    public void setWidth(int width) {
        this.field.m_93674_(width - 2);
    }

    @Override
    public int getWidth() {
        return this.field.m_5711_() + 2;
    }

    public void setHeight(int height) {
        this.field.setHeight(height - 2);
    }

    @Override
    public int getHeight() {
        return this.field.m_93694_() + 2;
    }

    public void setSize(int w, int h) {
        this.field.m_93674_(w - 2);
        this.field.setHeight(h - 2);
    }

    @Override
    public void setPos(int x, int y) {
        this.field.m_264152_(x + 1, y + 1);
    }

    @Override
    public int getX() {
        return this.field.m_252754_() - 1;
    }

    @Override
    public int getY() {
        return this.field.m_252907_() - 1;
    }

    public void setDisabled(boolean en) {
        boolean bl = this.enabled = !en;
        if (!en) {
            this.field.m_93692_(false);
        }
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.field.m_93692_(false);
        this.enabled = false;
    }

    public void setVisible(boolean vi) {
        this.field.m_94194_(vi);
    }

    public boolean isVisible() {
        return this.field.m_94213_();
    }

    public void show() {
        this.field.m_94194_(true);
    }

    public void hide() {
        this.field.m_94194_(false);
    }

    public void setFocused(boolean val) {
        this.field.m_93692_(val);
    }

    public boolean hasFocus() {
        return this.field.m_93696_();
    }

    public void focus() {
        this.field.m_93692_(true);
    }

    public void setTextColor(int color) {
        this.field.m_94202_(color);
        this.textColor = color;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setDisabledTextColor(int color) {
        this.field.m_94205_(color);
        this.disabledColor = color;
    }

    public int getDisabledTextColor() {
        return this.disabledColor;
    }

    public EditBox getMcField() {
        return this.field;
    }

    public void addTextChangeListener(TextChangeListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeTextChangeListener(TextChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.field.m_264152_(json.getInt("x", 0) + 1, json.getInt("y", 0) + 1);
        this.field.m_93674_(json.getInt("width", 200) - 2);
        this.field.setHeight(json.getInt("height", 22) - 2);
        this.field.m_94144_(TextField.tr(json.getString("text", "")));
        this.field.m_94194_(json.getBool("visible", true));
        this.field.m_94199_(json.getInt("maxLength", 32));
        this.enabled = !json.getBool("disabled", false);
        this.textColor = json.getColor("textColor", 0xE0E0E0);
        this.disabledColor = json.getColor("disabledColor", 0x707070);
        this.field.m_94202_(this.textColor);
        this.field.m_94205_(this.disabledColor);
        this.setFocused(false);
    }

    public static class EnterPressedEvent
    extends Event<TextField> {
        private final String text;

        public EnterPressedEvent(TextField field) {
            this.source = field;
            this.text = field.field.m_94155_();
        }

        public String getText() {
            return this.text;
        }
    }

    public static class TabPressedEvent
    extends Event<TextField> {
        private final String beginning;

        public TabPressedEvent(TextField field) {
            this.source = field;
            String text = field.field.m_94155_();
            int max = field.field.m_94207_();
            int spacePos = 0;
            for (int i = max - 1; i >= 0; --i) {
                if (!Character.isSpaceChar(text.charAt(i))) continue;
                spacePos = i;
                break;
            }
            this.beginning = text.substring(spacePos, max).trim();
        }

        public String getBeginning() {
            return this.beginning;
        }
    }

    public static interface TextChangeListener {
        public void onTextChange(TextField var1, String var2, String var3);
    }

    public static class TextChangedEvent
    extends Event<TextField> {
        private final String oldContent;
        private final String newContent;

        public TextChangedEvent(TextField tf, String old) {
            this.source = tf;
            this.oldContent = old;
            this.newContent = tf.field.m_94155_();
        }

        public String getOldContent() {
            return this.oldContent;
        }

        public String getNewContent() {
            return this.newContent;
        }
    }
}

