/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.swing.filechooser.FileSystemView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.CommandHandler;
import net.montoyo.wd.client.gui.GuiMinePad;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.miniserv.client.ClientTask;
import net.montoyo.wd.miniserv.client.ClientTaskCheckFile;
import net.montoyo.wd.miniserv.client.ClientTaskDeleteFile;
import net.montoyo.wd.miniserv.client.ClientTaskGetFileList;
import net.montoyo.wd.miniserv.client.ClientTaskGetQuota;
import net.montoyo.wd.miniserv.client.ClientTaskUploadFile;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;
import net.montoyo.wd.utilities.serialization.Util;

public class GuiServer
extends WDScreen {
    private static final ResourceLocation BG_IMAGE = new ResourceLocation("webdisplays", "textures/gui/server_bg.png");
    private static final ResourceLocation FG_IMAGE = new ResourceLocation("webdisplays", "textures/gui/server_fg.png");
    private static final HashMap<String, Method> COMMAND_MAP = new HashMap();
    private static final int MAX_LINE_LEN = 32;
    private static final int MAX_LINES = 12;
    private final Vector3i serverPos;
    private final NameUUIDPair owner;
    private final ArrayList<String> lines = new ArrayList();
    private String prompt = "";
    private String userPrompt;
    private int blinkTime;
    private String lastCmd;
    private boolean promptLocked;
    private volatile long queryTime;
    private ClientTask<?> currentTask;
    private int selectedLine = -1;
    private int accessTrials;
    private int accessTime;
    private int accessState = -1;
    private SimpleSoundInstance accessSound;
    private boolean uploadWizard;
    private File uploadDir;
    private final ArrayList<File> uploadFiles = new ArrayList();
    private int uploadOffset;
    private boolean uploadFirstIsParent;
    private String uploadFilter = "";
    private long uploadFilterTime;
    int queueRead = 0;
    ArrayList<String> queue = new ArrayList();

    public GuiServer(Vector3i vec, NameUUIDPair owner) {
        super(Component.m_130674_(null));
        this.serverPos = vec;
        this.owner = owner;
        this.userPrompt = "> ";
        if (COMMAND_MAP.isEmpty()) {
            GuiServer.buildCommandMap();
        }
        this.lines.add("MiniServ 1.0");
        this.lines.add(GuiServer.tr("info", new Object[0]));
        this.uploadCD(FileSystemView.getFileSystemView().getDefaultDirectory());
    }

    private static String tr(String key, Object ... args) {
        return I18n.m_118938_((String)("webdisplays.server." + key), (Object[])args);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float ptt) {
        super.m_88315_(graphics, mouseX, mouseY, ptt);
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 176) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_IMAGE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(BG_IMAGE, x, y, 0, 0, 256, 256);
        x += 18;
        y += 18;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.selectedLine == i) {
                this.drawWhiteQuad(x - 1, y - 2, this.f_96547_.m_92895_(this.lines.get(i)) + 1, 12);
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.lines.get(i), x, y, -15558912, false);
            } else {
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.lines.get(i), x, y, -1, false);
            }
            y += 12;
        }
        if (!this.promptLocked) {
            if (this.queue.isEmpty()) {
                x = graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.userPrompt, x, y, -1, false);
                x = graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.prompt, x, y, -1, false);
            } else {
                x = graphics.m_280056_(Minecraft.m_91087_().f_91062_, GuiServer.tr("press_for_more", new Object[0]), x, y, -1, false);
            }
        }
        if (!this.uploadWizard && this.blinkTime < 5) {
            this.drawWhiteQuad(x + 1, y, 6, 8);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)FG_IMAGE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawWhiteQuad(int x, int y, int w, int h) {
        float xd = x;
        float xd2 = x + w;
        float yd = y;
        float yd2 = y + h;
        float zd = this.getBlitOffset();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder bb = t.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bb.m_5483_((double)xd, (double)yd2, (double)zd).m_5752_();
        bb.m_5483_((double)xd2, (double)yd2, (double)zd).m_5752_();
        bb.m_5483_((double)xd2, (double)yd, (double)zd).m_5752_();
        bb.m_5483_((double)xd, (double)yd, (double)zd).m_5752_();
        t.m_85914_();
    }

    private float getBlitOffset() {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void m_86600_() {
        int maxl;
        super.m_86600_();
        if (this.accessState >= 0) {
            if (--this.accessTime <= 0) {
                ++this.accessState;
                if (this.accessState == 1) {
                    if (this.lines.size() > 0) {
                        this.lines.remove(this.lines.size() - 1);
                    }
                    this.lines.add("access: PERMISSION DENIED....and...");
                    this.accessTime = 20;
                } else {
                    if (this.accessSound == null) {
                        this.accessSound = new SimpleSoundInstance(WebDisplays.INSTANCE.soundServer.m_11660_(), SoundSource.MASTER, 1.0f, 1.0f, RandomSource.m_216327_(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, false);
                        this.f_96541_.m_91106_().m_120367_((SoundInstance)this.accessSound);
                    }
                    this.writeLine("YOU DIDN'T SAY THE MAGIC WORD!");
                    this.accessTime = 2;
                }
            }
        } else {
            this.blinkTime = (this.blinkTime + 1) % 10;
            if (this.currentTask != null) {
                long queryTime;
                GuiServer guiServer = this;
                synchronized (guiServer) {
                    queryTime = this.queryTime;
                }
                if (System.currentTimeMillis() - queryTime >= 10000L) {
                    this.writeLine(GuiServer.tr("timeout", new Object[0]));
                    this.currentTask.cancel();
                    this.clearTask();
                }
            }
            if (!this.uploadFilter.isEmpty() && System.currentTimeMillis() - this.uploadFilterTime >= 1000L) {
                Log.info("Upload filter cleared", new Object[0]);
                this.uploadFilter = "";
            }
        }
        int n = maxl = this.uploadWizard ? 12 : 11;
        if (!this.queue.isEmpty()) {
            while (!this.queue.isEmpty() && this.lines.size() < maxl) {
                this.writeLine(this.queue.remove(0));
            }
        }
        while (this.lines.size() > maxl) {
            this.lines.remove(0);
        }
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Supplier<Boolean> predicate = () -> super.m_7920_(keyCode, scanCode, modifiers);
        try {
            return this.handleKeyboardInput(keyCode, false, predicate);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && !this.uploadWizard) {
            Minecraft.m_91087_().m_91152_(null);
            return true;
        }
        GuiMinePad.getChar(keyCode, scanCode).ifPresent(c -> {
            try {
                this.keyTyped(c.charValue(), keyCode, modifiers);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try {
            return this.handleKeyboardInput(keyCode, true, () -> true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean handleKeyboardInput(int keyCode, boolean keyState, Supplier<Boolean> booleanSupplier) throws IOException {
        if (!this.queue.isEmpty()) {
            return false;
        }
        if (this.uploadWizard) {
            if (keyState) {
                if (keyCode == 265) {
                    if (this.selectedLine > 3) {
                        --this.selectedLine;
                    } else if (this.uploadOffset > 0) {
                        --this.uploadOffset;
                        this.updateUploadScreen();
                    }
                } else if (keyCode == 264) {
                    if (this.selectedLine < 11) {
                        ++this.selectedLine;
                    } else if (this.uploadOffset + this.selectedLine - 2 < this.uploadFiles.size()) {
                        ++this.uploadOffset;
                        this.updateUploadScreen();
                    }
                } else if (keyCode == 267) {
                    this.selectedLine = 3;
                    int dst = this.uploadOffset - 9;
                    if (dst < 0) {
                        dst = 0;
                    }
                    this.selectFile(dst);
                } else if (keyCode == 266) {
                    this.selectedLine = 3;
                    int dst = this.uploadOffset + 9;
                    if (dst >= this.uploadFiles.size()) {
                        dst = this.uploadFiles.size() - 1;
                    }
                    this.selectFile(dst);
                } else if (keyCode == 257 || keyCode == 335) {
                    File file = this.uploadFiles.get(this.uploadOffset + this.selectedLine - 3);
                    if (file.isDirectory()) {
                        this.uploadCD(file);
                        this.updateUploadScreen();
                    } else {
                        this.startFileUpload(file, true);
                    }
                } else if (keyCode == 294) {
                    this.uploadCD(this.uploadDir);
                    this.updateUploadScreen();
                }
            }
            if (keyCode == 256) {
                this.quitUploadWizard();
                return true;
            }
            return booleanSupplier.get();
        }
        boolean value = booleanSupplier.get();
        if (keyState) {
            boolean ctrl = Screen.m_96637_();
            if (keyCode == 76 && ctrl) {
                this.lines.clear();
            } else if (keyCode == 86 && ctrl) {
                this.prompt = this.prompt + Minecraft.m_91087_().f_91068_.m_90876_();
                if (this.prompt.length() > 32) {
                    this.prompt = this.prompt.substring(0, 32);
                }
            } else if (keyCode == 265 && this.lastCmd != null) {
                String tmp = this.prompt;
                this.prompt = this.lastCmd;
                this.lastCmd = tmp;
            }
        }
        return value;
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers);
    }

    protected void keyTyped(char typedChar, int keyCode, int modifier) throws IOException {
        if (keyCode == 264 && !this.queue.isEmpty()) {
            this.writeLine(this.queue.remove(0));
            return;
        }
        if (!this.queue.isEmpty()) {
            return;
        }
        if (this.uploadWizard) {
            int i;
            boolean found = false;
            this.uploadFilter = this.uploadFilter + Character.toLowerCase(typedChar);
            this.uploadFilterTime = System.currentTimeMillis();
            int n = i = this.uploadFirstIsParent ? 1 : 0;
            while (i < this.uploadFiles.size()) {
                if (this.uploadFiles.get(i).getName().toLowerCase().startsWith(this.uploadFilter)) {
                    this.selectFile(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found && this.uploadFilter.length() == 1) {
                this.uploadFilter = "";
            }
            return;
        }
        if (this.promptLocked) {
            return;
        }
        if (keyCode == 32) {
            typedChar = (char)32;
        }
        if ((typedChar == 'v' || typedChar == 'V') && (modifier & 2) == 2) {
            return;
        }
        if (keyCode == 259) {
            if (this.prompt.length() > 0) {
                this.prompt = this.prompt.substring(0, this.prompt.length() - 1);
            }
        } else if (keyCode == 257 || keyCode == 335) {
            if (this.prompt.length() > 0) {
                this.writeLine(this.userPrompt + this.prompt);
                this.evaluateCommand(this.prompt);
                this.lastCmd = this.prompt;
                this.prompt = "";
            } else {
                this.writeLine(this.userPrompt);
            }
        } else if (this.prompt.length() + 1 < 32 && typedChar >= ' ' && typedChar <= '~') {
            this.prompt = this.prompt + typedChar;
        }
        this.blinkTime = 0;
    }

    private void evaluateCommand(String str) {
        Object[] params;
        String[] args = str.trim().split("\\s+");
        Method handler = COMMAND_MAP.get(args[0].toLowerCase());
        if (handler == null) {
            this.writeLine(GuiServer.tr("unknowncmd", new Object[0]));
            return;
        }
        if (handler.getParameterCount() == 0) {
            params = new Object[]{};
        } else {
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            params = new Object[]{args2};
        }
        try {
            handler.invoke((Object)this, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Log.errorEx("Caught exception while running command \"%s\"", e, str);
            this.writeLine(GuiServer.tr("error", new Object[0]));
        }
    }

    private void writeLine(String line) {
        int maxl;
        int n = maxl = this.uploadWizard ? 12 : 11;
        while (this.lines.size() >= maxl) {
            this.lines.remove(0);
        }
        this.lines.add(line);
    }

    private static void buildCommandMap() {
        Method[] methods;
        COMMAND_MAP.clear();
        for (Method m : methods = GuiServer.class.getMethods()) {
            CommandHandler cmd = m.getAnnotation(CommandHandler.class);
            if (cmd == null || !Modifier.isPublic(m.getModifiers()) || m.getParameterCount() != 0 && (m.getParameterCount() != 1 || m.getParameterTypes()[0] != String[].class)) continue;
            COMMAND_MAP.put(cmd.value().toLowerCase(), m);
        }
    }

    private void quitUploadWizard() {
        this.lines.clear();
        this.promptLocked = false;
        this.uploadWizard = false;
        this.selectedLine = -1;
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        if (this.accessSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.accessSound);
        }
    }

    private boolean queueTask(ClientTask<?> task) {
        if (Client.getInstance().addTask(task)) {
            this.promptLocked = true;
            this.queryTime = System.currentTimeMillis();
            this.currentTask = task;
            return true;
        }
        this.writeLine(GuiServer.tr("queryerr", new Object[0]));
        return false;
    }

    private void clearTask() {
        this.promptLocked = false;
        this.currentTask = null;
    }

    private static String trimStringL(String str) {
        int delta = str.length() - 32;
        if (delta <= 0) {
            return str;
        }
        return "..." + str.substring(delta + 3);
    }

    private static String trimStringR(String str) {
        return str.length() <= 32 ? str : str.substring(0, 29) + "...";
    }

    @CommandHandler(value="clear")
    public void commandClear() {
        this.lines.clear();
    }

    @CommandHandler(value="help")
    public void commandHelp(String[] args) {
        this.queueRead = this.lines.size();
        if (args.length > 0) {
            String cmd = args[0].toLowerCase();
            if (COMMAND_MAP.containsKey(cmd)) {
                this.queueLine(GuiServer.tr("help." + cmd, new Object[0]));
            } else {
                this.queueLine(GuiServer.tr("unknowncmd", new Object[0]));
            }
        } else {
            for (String c : COMMAND_MAP.keySet()) {
                this.queueLine(c + " - " + GuiServer.tr("help." + c, new Object[0]));
            }
        }
    }

    @CommandHandler(value="exit")
    public void commandExit() {
        this.f_96541_.m_91152_(null);
    }

    @CommandHandler(value="access")
    public void commandAccess(String[] args) {
        boolean handled = false;
        if (args.length >= 1 && args[0].equalsIgnoreCase("security")) {
            if (args.length == 1 || args.length == 2 && args[1].equalsIgnoreCase("grid")) {
                handled = true;
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("main") && args[1].equalsIgnoreCase("security") && args[2].equalsIgnoreCase("grid")) {
            handled = true;
        }
        if (handled) {
            this.writeLine("access: PERMISSION DENIED.");
            if (++this.accessTrials >= 3) {
                this.promptLocked = true;
                this.accessState = 0;
                this.accessTime = 20;
            }
        } else {
            this.writeLine(GuiServer.tr("argerror", new Object[0]));
        }
    }

    @CommandHandler(value="owner")
    public void commandOwner() {
        this.writeLine(GuiServer.tr("ownername", this.owner.name));
        this.writeLine(GuiServer.tr("owneruuid", new Object[0]));
        this.writeLine(this.owner.uuid.toString());
    }

    @CommandHandler(value="quota")
    public void commandQuota() {
        if (!this.f_96541_.f_91074_.m_36316_().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        ClientTaskGetQuota task = new ClientTaskGetQuota();
        task.setFinishCallback(t -> {
            this.writeLine(GuiServer.tr("quota", Util.sizeString(t.getQuota()), Util.sizeString(t.getMaxQuota())));
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="ls")
    public void commandList() {
        ClientTaskGetFileList task = new ClientTaskGetFileList(this.owner.uuid);
        task.setFinishCallback(t -> {
            String[] files = t.getFileList();
            if (files != null) {
                Arrays.stream(files).forEach(this::writeLine);
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="url")
    public void commandURL(String[] args) {
        if (args.length < 1) {
            this.writeLine(GuiServer.tr("fnamearg", new Object[0]));
            return;
        }
        String fname = Util.join(args, " ");
        if (Util.isFileNameInvalid(fname)) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        ClientTaskCheckFile task = new ClientTaskCheckFile(this.owner.uuid, fname);
        task.setFinishCallback(t -> {
            int status = t.getStatus();
            if (status == 0) {
                this.writeLine(GuiServer.tr("urlcopied", new Object[0]));
                Minecraft.m_91087_().f_91068_.m_90911_(t.getURL());
            } else if (status == 2) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
            } else {
                this.writeLine(GuiServer.tr("error2", status));
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    private void uploadCD(File newDir) {
        try {
            this.uploadDir = newDir.getCanonicalFile();
        }
        catch (IOException ex) {
            this.uploadDir = newDir;
        }
        this.uploadFiles.clear();
        File parent = this.uploadDir.getParentFile();
        if (parent != null && parent.exists()) {
            this.uploadFiles.add(parent);
            this.uploadFirstIsParent = true;
        } else {
            this.uploadFirstIsParent = false;
        }
        File[] children = this.uploadDir.listFiles();
        if (children != null) {
            Collator c = Collator.getInstance();
            c.setStrength(1);
            c.setDecomposition(1);
            Arrays.stream(children).filter(f -> !f.isHidden() && (f.isDirectory() || f.isFile())).sorted((a, b) -> c.compare(a.getName(), b.getName())).forEach(this.uploadFiles::add);
        }
        this.uploadOffset = 0;
        this.uploadFilter = "";
        if (this.uploadWizard) {
            this.selectedLine = 3;
        }
    }

    private void updateUploadScreen() {
        this.lines.clear();
        this.lines.add(GuiServer.tr("upload.info", new Object[0]));
        this.lines.add(GuiServer.trimStringL(this.uploadDir.getPath()));
        this.lines.add("");
        for (int i = this.uploadOffset; i < this.uploadFiles.size() && this.lines.size() < 12; ++i) {
            if (i == 0 && this.uploadFirstIsParent) {
                this.lines.add(GuiServer.tr("upload.parent", new Object[0]));
                continue;
            }
            this.lines.add(GuiServer.trimStringR(this.uploadFiles.get(i).getName()));
        }
    }

    private void selectFile(int i) {
        int pos = 3 + i - this.uploadOffset;
        if (pos >= 3 && pos < 12) {
            this.selectedLine = pos;
            return;
        }
        this.uploadOffset = i;
        if (this.uploadOffset + 12 - 3 > this.uploadFiles.size()) {
            this.uploadOffset = this.uploadFiles.size() - 12 + 3;
        }
        this.updateUploadScreen();
        this.selectedLine = 3 + i - this.uploadOffset;
    }

    @CommandHandler(value="upload")
    public void commandUpload(String[] args) {
        if (!this.f_96541_.f_91074_.m_36316_().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        if (args.length > 0) {
            File fle = new File(Util.join(args, " "));
            if (!fle.exists()) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
                return;
            }
            if (fle.isDirectory()) {
                this.uploadCD(fle);
            } else {
                if (fle.isFile()) {
                    this.startFileUpload(fle, false);
                    return;
                }
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
                return;
            }
        }
        this.uploadWizard = true;
        this.promptLocked = true;
        this.uploadOffset = 0;
        this.selectedLine = 3;
        this.updateUploadScreen();
    }

    @CommandHandler(value="rm")
    public void commandDelete(String[] args) {
        if (!this.f_96541_.f_91074_.m_36316_().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        if (args.length < 1) {
            this.writeLine(GuiServer.tr("fnamearg", new Object[0]));
            return;
        }
        String fname = Util.join(args, " ");
        if (Util.isFileNameInvalid(fname)) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        ClientTaskDeleteFile task = new ClientTaskDeleteFile(fname);
        task.setFinishCallback(t -> {
            int status = t.getStatus();
            if (status == 1) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
            } else if (status != 0) {
                this.writeLine(GuiServer.tr("error", new Object[0]));
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="reconnect")
    public void commandReconnect() {
        Client.getInstance().stop();
        WDNetworkRegistry.INSTANCE.sendToServer((Object)Client.getInstance().beginConnection());
    }

    private void startFileUpload(File f, boolean quit) {
        ClientTaskUploadFile task;
        if (quit) {
            this.quitUploadWizard();
        }
        if (Util.isFileNameInvalid(f.getName()) || f.getName().length() >= 29) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        try {
            task = new ClientTaskUploadFile(f);
        }
        catch (IOException ex) {
            this.writeLine(GuiServer.tr("error", new Object[0]));
            ex.printStackTrace();
            return;
        }
        task.setProgressCallback((cur, total) -> {
            GuiServer guiServer = this;
            synchronized (guiServer) {
                this.queryTime = System.currentTimeMillis();
            }
        });
        task.setFinishCallback(t -> {
            int status = t.getUploadStatus();
            if (status == 0) {
                this.writeLine(GuiServer.tr("upload.done", new Object[0]));
            } else if (status == 5) {
                this.writeLine(GuiServer.tr("upload.exists", new Object[0]));
            } else if (status == 3) {
                this.writeLine(GuiServer.tr("upload.quota", new Object[0]));
            } else {
                this.writeLine(GuiServer.tr("error2", status));
            }
            this.clearTask();
        });
        if (this.queueTask(task)) {
            this.writeLine(GuiServer.tr("upload.uploading", new Object[0]));
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return this.serverPos.equalsBlockPos(bp);
    }

    @Override
    @Nullable
    public String getWikiPageName() {
        return "Server";
    }

    private void queueLine(String line) {
        int maxl;
        int n = maxl = this.uploadWizard ? 12 : 11;
        if (this.lines.size() < maxl) {
            this.writeLine(line);
        } else if (this.queueRead > 1) {
            this.writeLine(line);
            --this.queueRead;
        } else {
            this.queue.add(line);
        }
    }
}

