/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.camera.KeyboardCamera;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Label;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.server_bound.C2SMessageScreenCtrl;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector2i;
import net.montoyo.wd.utilities.serialization.TypeData;
import net.montoyo.wd.utilities.serialization.Util;
import org.cef.browser.CefBrowser;
import org.cef.misc.CefCursorType;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;

@OnlyIn(value=Dist.CLIENT)
public class GuiKeyboard
extends WDScreen {
    private static final String WARNING_FNAME = "wd_keyboard_warning.txt";
    private ScreenBlockEntity tes;
    private BlockSide side;
    private ScreenData data;
    private final ArrayList<TypeData> evStack = new ArrayList();
    private BlockPos kbPos;
    private boolean showWarning = true;
    @FillControl
    private Label lblInfo;
    @FillControl
    private Button btnOk;
    private static final boolean vivecraftPresent;

    public GuiKeyboard() {
        super(Component.m_130674_(null));
    }

    public GuiKeyboard(ScreenBlockEntity tes, BlockSide side, BlockPos kbPos) {
        this();
        this.tes = tes;
        this.side = side;
        this.kbPos = kbPos;
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("showWarning", this.showWarning ? 1.0 : 0.0);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.showWarning = this.f_96541_.m_91092_() != null && !this.f_96541_.m_91092_().m_6992_() ? false : !this.hasUserReadWarning();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/kb_right.json"));
        if (this.showWarning) {
            int maxLabelW = 0;
            int totalH = 0;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo || !(ctrl instanceof Label)) continue;
                if (ctrl.getWidth() > maxLabelW) {
                    maxLabelW = ctrl.getWidth();
                }
                totalH += ctrl.getHeight();
                ctrl.setPos((this.f_96543_ - ctrl.getWidth()) / 2, 0);
            }
            this.btnOk.setWidth(maxLabelW);
            this.btnOk.setPos((this.f_96543_ - maxLabelW) / 2, 0);
            int y = (this.f_96544_ - (totalH += this.btnOk.getHeight())) / 2;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo) continue;
                ctrl.setPos(ctrl.getX(), y);
                y += ctrl.getHeight();
            }
        } else if (!this.f_96541_.m_91302_()) {
            this.f_96541_.m_7440_(true);
            this.f_96541_.f_91067_.m_91601_();
        }
        this.defaultBackground = this.showWarning;
        this.syncTicks = 5;
        if (vivecraftPresent && VRPlayer.get() != null) {
            KeyboardHandler.setOverlayShowing((boolean)true);
        }
        KeyboardCamera.focus(this.tes, this.side);
        this.data = this.tes.getScreen(this.side);
        CefBrowser browser = this.data.browser;
        ((MCEFBrowser)browser).setCursor(CefCursorType.fromId((int)this.data.mouseType));
        ((MCEFBrowser)browser).setCursorChangeListener(id -> {
            this.data.mouseType = id;
            ((MCEFBrowser)browser).setCursor(CefCursorType.fromId((int)id));
        });
    }

    public void m_7861_() {
        super.m_7861_();
        if (vivecraftPresent && VRPlayer.get() != null) {
            KeyboardHandler.setOverlayShowing((boolean)false);
        }
        KeyboardCamera.focus(null, null);
        CefBrowser browser = this.data.browser;
        if (browser instanceof MCEFBrowser) {
            MCEFBrowser mcef = (MCEFBrowser)browser;
            mcef.setCursor(CefCursorType.POINTER);
            mcef.setCursorChangeListener(cursor -> {
                this.data.mouseType = cursor;
            });
        }
    }

    @Override
    public void m_7379_() {
        this.m_7861_();
        super.m_7379_();
        this.f_96541_.popGuiLayer();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.quitOnEscape && keyCode == 256) {
            this.m_7379_();
            return true;
        }
        this.addKey(new TypeData(TypeData.Action.PRESS, keyCode, modifiers, scanCode));
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        this.addKey(new TypeData(TypeData.Action.TYPE, codePoint, modifiers, 0));
        return super.m_5534_(codePoint, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.addKey(new TypeData(TypeData.Action.RELEASE, keyCode, modifiers, scanCode));
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    void addKey(TypeData data) {
        this.tes.type(this.side, "[" + WebDisplays.GSON.toJson((Object)data) + "]", this.kbPos);
        this.evStack.add(data);
        if (!this.evStack.isEmpty() && !this.syncRequested()) {
            this.requestSync();
        }
    }

    @Override
    protected void sync() {
        if (!this.evStack.isEmpty()) {
            WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.type(this.tes, this.side, WebDisplays.GSON.toJson(this.evStack), this.kbPos));
            this.evStack.clear();
        }
    }

    @GuiSubscribe
    public void onClick(Button.ClickEvent ev) {
        if (this.showWarning && ev.getSource() == this.btnOk) {
            this.writeUserAcknowledge();
            for (Control ctrl : this.controls) {
                Label lbl;
                if (!(ctrl instanceof Label)) continue;
                lbl.setVisible(!(lbl = (Label)ctrl).isVisible());
            }
            this.btnOk.setDisabled(true);
            this.btnOk.setVisible(false);
            this.showWarning = false;
            this.defaultBackground = false;
            this.f_96541_.m_7440_(true);
            this.f_96541_.f_91067_.m_91601_();
        }
    }

    private boolean hasUserReadWarning() {
        try {
            File f = new File(FMLPaths.GAMEDIR.get().toString(), WARNING_FNAME);
            if (f.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String str = br.readLine();
                Util.silentClose(br);
                return str != null && str.trim().equalsIgnoreCase("read");
            }
        }
        catch (Throwable t) {
            Log.warningEx("Can't know if user has already read the warning", t, new Object[0]);
        }
        return false;
    }

    private void writeUserAcknowledge() {
        try {
            File f = new File(FMLPaths.GAMEDIR.get().toString(), WARNING_FNAME);
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("read\n");
            Util.silentClose(bw);
        }
        catch (Throwable t) {
            Log.warningEx("Can't write that the user read the warning", t, new Object[0]);
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return bp.equals((Object)this.kbPos) || bp.equals((Object)this.tes.m_58899_()) && side == this.side;
    }

    protected void mouse(double mouseX, double mouseY, Consumer<Vector2i> func) {
        float pct = Minecraft.m_91087_().getPartialTick();
        ViewportEvent.ComputeFov fov = new ViewportEvent.ComputeFov(Minecraft.m_91087_().f_91063_, Minecraft.m_91087_().m_91290_().f_114358_, (double)pct, (double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue(), true);
        mouseX /= (double)this.f_96543_;
        mouseY /= (double)this.f_96544_;
        mouseX -= 0.5;
        mouseY -= 0.5;
        mouseY = -mouseY;
        Matrix4f proj = Minecraft.m_91087_().f_91063_.m_253088_(fov.getFOV());
        Entity e = Minecraft.m_91087_().m_91290_().f_114358_.m_90592_();
        PoseStack camera = new PoseStack();
        float[] angle = KeyboardCamera.getAngle(e, pct);
        camera.m_252781_(Axis.f_252529_.m_252977_(angle[0]));
        camera.m_252781_(Axis.f_252436_.m_252977_(angle[1] + 180.0f));
        Vector4f coord = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        coord.add((Vector4fc)proj.invert().transform(new Vector4f(2.0f * (float)mouseX, 2.0f * (float)mouseY, 0.0f, 1.0f)));
        coord = camera.m_85850_().m_252922_().invert().transform(coord);
        coord.w = 0.0f;
        coord.normalize();
        Vec3 vec3 = e.m_20299_(pct);
        Vec3 vec31 = new Vec3((double)coord.x, (double)coord.y, (double)coord.z);
        BlockHitResult result = this.tes.trace(this.side, vec3, vec31);
        if (result.m_6662_() != HitResult.Type.MISS) {
            this.tes.interact(result, func);
        }
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        this.mouse(mouseX, mouseY, hit -> {
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.MOVE, (Vector2i)hit, -1);
            WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserMove(this.tes, this.side, hit));
        });
        super.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouse(mouseX, mouseY, hit -> {
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.MOVE, (Vector2i)hit, -1);
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.DOWN, (Vector2i)hit, button);
            WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserDown(this.tes, this.side, hit, button));
        });
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouse(mouseX, mouseY, hit -> {
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.MOVE, (Vector2i)hit, -1);
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.UP, (Vector2i)hit, button);
            WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserUp(this.tes, this.side, button));
        });
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public void m_86600_() {
        double mouseX = Minecraft.m_91087_().f_91067_.m_91589_() / (double)Minecraft.m_91087_().m_91268_().m_85441_();
        double mouseY = Minecraft.m_91087_().f_91067_.m_91594_() / (double)Minecraft.m_91087_().m_91268_().m_85442_();
        this.mouse(mouseX * (double)this.f_96543_, mouseY * (double)this.f_96544_, hit -> {
            this.tes.handleMouseEvent(this.side, ClickControl.ControlType.MOVE, (Vector2i)hit, -1);
            WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserMove(this.tes, this.side, hit));
        });
        super.m_86600_();
    }

    static {
        boolean vivePres = false;
        if (ModList.get().isLoaded("vivecraft")) {
            vivePres = true;
        } else {
            try {
                Method m;
                Class<?> clazz = Class.forName("org.vivecraft.gameplay.screenhandlers.KeyboardHandler");
                vivePres = clazz == null ? false : (m = clazz.getMethod("setOverlayShowing", Boolean.TYPE)) != null;
            }
            catch (Throwable ignored) {
                vivePres = false;
            }
        }
        vivecraftPresent = vivePres;
    }
}

