/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.datagen.APAdvancements;
import architectspalette.core.datagen.APBlockTags;
import architectspalette.core.datagen.APInternalData;
import architectspalette.core.datagen.APItemTags;
import architectspalette.core.datagen.APLang;
import architectspalette.core.datagen.APLootTables;
import architectspalette.core.datagen.APRecipes;
import architectspalette.core.datagen.Blockstates;
import java.util.List;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GatherData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput pack = generator.getPackOutput();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(pack, event.getLookupProvider(), event.getExistingFileHelper(), List.of(new APAdvancements())));
            APBlockTags blocktagger = new APBlockTags(pack, event.getLookupProvider(), event.getExistingFileHelper());
            generator.addProvider(true, (DataProvider)blocktagger);
            generator.addProvider(true, (DataProvider)new APItemTags(pack, event.getLookupProvider(), (TagsProvider<Block>)blocktagger, event.getExistingFileHelper()));
            generator.addProvider(true, (DataProvider)new APLootTables(pack));
            generator.addProvider(true, (DataProvider)new APRecipes(pack));
            generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(pack, event.getLookupProvider(), APInternalData.getRegistrySetBuilder(), Set.of("architects_palette")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, packOutput -> new Blockstates(packOutput, "architects_palette", event.getExistingFileHelper()));
            generator.addProvider(true, (DataProvider)new APLang(pack));
        }
    }
}

