/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.content.blocks.TotemWingBlock;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.registry.APBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class TotemBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public final TotemWingBlock WING_BLOCK;
    public final TotemFace totemType;

    public TotemBlock(BlockBehaviour.Properties properties, TotemWingBlock wingBlock, TotemFace face) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.WING_BLOCK = wingBlock;
        this.totemType = face;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            boolean waterlogged;
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122427_());
            boolean bl = waterlogged = worldIn.m_6425_(blockpos).m_76152_() == Fluids.f_76193_;
            if (worldIn.m_46859_(blockpos) || waterlogged) {
                worldIn.m_7731_(blockpos, (BlockState)((BlockState)this.WING_BLOCK.m_49966_().m_61124_((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122427_())).m_61124_((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            boolean bl2 = waterlogged = worldIn.m_6425_(blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122428_())).m_76152_() == Fluids.f_76193_;
            if (worldIn.m_46859_(blockpos) || waterlogged) {
                worldIn.m_7731_(blockpos, (BlockState)((BlockState)this.WING_BLOCK.m_49966_().m_61124_((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122428_())).m_61124_((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack playerItem = player.m_21120_(handIn);
        if (playerItem.m_41720_() instanceof AxeItem) {
            BlockState newState = (BlockState)this.totemType.getStrip().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
            worldIn.m_7731_(pos, newState, 3);
            playerItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            worldIn.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                APCriterion.CARVE_TOTEM.trigger((ServerPlayer)player);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public static enum TotemFace {
        GRINNING,
        PLACID,
        SHOCKED,
        BLANK;


        public Block getStrip() {
            switch (this) {
                case GRINNING: {
                    return (Block)APBlocks.PLACID_ACACIA_TOTEM.get();
                }
                case PLACID: {
                    return (Block)APBlocks.SHOCKED_ACACIA_TOTEM.get();
                }
                case SHOCKED: {
                    return (Block)APBlocks.BLANK_ACACIA_TOTEM.get();
                }
            }
            return (Block)APBlocks.GRINNING_ACACIA_TOTEM.get();
        }
    }
}

