/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat;

import architectspalette.compat.JEIPlugin;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.registry.APBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WarpingRecipeCategory
implements IRecipeCategory<WarpingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("architects_palette", "warping");
    private final Component title = Component.m_237115_((String)"architects_palette.info.warping_recipe_title");
    private final IDrawable background;
    private final IDrawable icon;

    public WarpingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("architects_palette", "textures/gui/warping_recipe.png"), 0, 0, 117, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)APBlocks.WARPSTONE.get()));
    }

    public RecipeType<WarpingRecipe> getRecipeType() {
        return JEIPlugin.WARPING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WarpingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 22).addItemStacks(Arrays.asList(recipe.getInput().m_43908_()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 87, 22).addItemStack(recipe.getResult());
    }

    public List<Component> getTooltipStrings(WarpingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> strings = new ArrayList<Component>();
        if (WarpingRecipeCategory.pointInBox(mouseX, mouseY, 49.0, 12.0, 18.0, 35.0)) {
            ResourceLocation targetDimension = recipe.getDimension();
            MutableComponent dimensionName = Component.m_237115_((String)("architects_palette.info.dimension." + targetDimension.toString().replace(":", ".")));
            MutableComponent tossPrompt = Component.m_237110_((String)"architects_palette.info.warping_toss_description", (Object[])new Object[]{dimensionName});
            strings.add((Component)tossPrompt);
        }
        return strings;
    }

    private static boolean pointInBox(double x, double y, double left, double top, double width, double height) {
        return x >= left && x <= left + width && y >= top && y <= top + height;
    }
}

