/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.math;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.moddingx.libx.util.math.DoublePolynomial;
import org.moddingx.libx.util.math.Polynomial;

public final class IntPolynomial
extends Polynomial<Integer>
implements IntUnaryOperator,
IntFunction<Integer> {
    public static final Codec<IntPolynomial> CODEC = Codec.INT_STREAM.xmap(ints -> new IntPolynomial(ints.dropWhile(d -> d == 0).toArray(), true), p -> p.coefficients.length == 0 ? IntStream.of(0) : Arrays.stream(p.coefficients));
    public static final IntPolynomial ZERO = new IntPolynomial(0);
    public static final IntPolynomial ONE = new IntPolynomial(1);
    public static final IntPolynomial IDENTITY = new IntPolynomial(1, 0);
    private final int[] coefficients;
    private final boolean zero;
    private final boolean id;
    private List<Integer> coefficientsView;

    private IntPolynomial(int[] coefficients, boolean direct) {
        if (direct) {
            this.coefficients = coefficients;
        } else {
            int skip;
            for (skip = 0; skip < coefficients.length && coefficients[skip] == 0; ++skip) {
            }
            this.coefficients = new int[coefficients.length - skip];
            System.arraycopy(coefficients, skip, this.coefficients, 0, this.coefficients.length);
        }
        this.zero = this.coefficients.length == 0;
        this.id = this.coefficients.length == 2 && this.coefficients[0] == 1 && this.coefficients[1] == 0;
        this.coefficientsView = null;
    }

    public IntPolynomial(int ... coefficients) {
        this(coefficients, false);
    }

    @Override
    public List<Integer> coefficients() {
        if (this.coefficientsView != null) {
            return this.coefficientsView;
        }
        this.coefficientsView = Arrays.stream(this.coefficients).boxed().toList();
        return this.coefficientsView;
    }

    @Override
    public int applyAsInt(int x) {
        if (this.zero) {
            return 0;
        }
        if (this.id) {
            return x;
        }
        int pow = 1;
        int result = 0;
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            result += this.coefficients[i] * pow;
            pow *= x;
        }
        return result;
    }

    @Override
    public Integer apply(int x) {
        return this.applyAsInt(x);
    }

    @Override
    public Integer apply(Integer x) {
        return this.applyAsInt(x);
    }

    public IntPolynomial derivative() {
        if (this.coefficients.length == 0) {
            return this;
        }
        int[] coefficients = new int[this.coefficients.length - 1];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] * (this.coefficients.length - i - 1);
        }
        return new IntPolynomial(coefficients, true);
    }

    public IntPolynomial negate() {
        if (this.coefficients.length == 0) {
            return this;
        }
        int[] coefficients = new int[this.coefficients.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = -this.coefficients[i];
        }
        return new IntPolynomial(coefficients, true);
    }

    public IntPolynomial add(Polynomial<Integer> other) {
        int[] otherCoefficients = IntPolynomial.trustedCoefficients(other);
        int[] coefficients = new int[Math.max(this.coefficients.length, otherCoefficients.length)];
        int thisOffset = coefficients.length - this.coefficients.length;
        int otherOffset = coefficients.length - otherCoefficients.length;
        for (int i = 0; i < coefficients.length; ++i) {
            int thisPart = i - thisOffset >= 0 ? this.coefficients[i - thisOffset] : 0;
            int otherPart = i - otherOffset >= 0 ? otherCoefficients[i - otherOffset] : 0;
            coefficients[i] = thisPart + otherPart;
        }
        return new IntPolynomial(coefficients, false);
    }

    public IntPolynomial multiply(Polynomial<Integer> other) {
        int[] otherCoefficients = IntPolynomial.trustedCoefficients(other);
        int[] coefficients = new int[this.coefficients.length + otherCoefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < otherCoefficients.length; ++j) {
                int idx;
                int n = idx = coefficients.length - (this.coefficients.length - i - 1 + (otherCoefficients.length - j - 1)) - 1;
                coefficients[n] = coefficients[n] + this.coefficients[i] * otherCoefficients[j];
            }
        }
        return new IntPolynomial(coefficients, false);
    }

    public DoublePolynomial toDouble() {
        double[] coefficients = new double[this.coefficients.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i];
        }
        return new DoublePolynomial(coefficients);
    }

    private static int[] trustedCoefficients(Polynomial<Integer> other) {
        if (other instanceof IntPolynomial) {
            IntPolynomial polynomial = (IntPolynomial)other;
            return polynomial.coefficients;
        }
        return other.coefficients().stream().mapToInt(Integer::valueOf).toArray();
    }

    public int hashCode() {
        return Arrays.hashCode(this.coefficients);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof IntPolynomial)) return false;
        IntPolynomial other = (IntPolynomial)obj;
        if (!Arrays.equals(this.coefficients, other.coefficients)) return false;
        return true;
    }
}

