/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.lazy;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.LazyLoadedValue;
import net.minecraftforge.common.util.LazyOptional;

public class LazyValue<T> {
    private Supplier<? extends T> supplier;
    private T value;
    private Exception evaluationException;

    public LazyValue(@Nonnull Supplier<? extends T> supplier) {
        this.supplier = supplier;
        this.value = null;
        this.evaluationException = null;
    }

    public static <T> LazyValue<T> wrap(LazyLoadedValue<T> value) {
        return new LazyValue<Object>(() -> value.m_13971_());
    }

    public T get() {
        if (this.supplier != null) {
            try {
                this.value = this.supplier.get();
                this.supplier = null;
            }
            catch (Exception e) {
                this.value = null;
                this.evaluationException = e;
            }
            finally {
                this.supplier = null;
            }
        }
        if (this.evaluationException != null) {
            throw new IllegalStateException("Evaluation of LazyValue failed", this.evaluationException);
        }
        return this.value;
    }

    public LazyValue<T> asDefault(LazyOptional<T> optional) {
        return new LazyValue<Object>(() -> optional.resolve().orElseGet(this::get));
    }

    public <U> LazyValue<U> map(Function<T, U> mapper) {
        return new LazyValue<Object>(() -> mapper.apply(this.get()));
    }
}

