/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.moddingx.libx.LibX;

public class RenderHelper {
    public static final ResourceLocation TEXTURE_WHITE = LibX.getInstance().resource("textures/white.png");
    public static final ResourceLocation TEXTURE_CHEST_GUI = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");

    public static void repeatBlit(GuiGraphics graphics, int x, int y, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(graphics, sprite.m_247685_(), x, y, sprite.m_245424_().m_246492_(), sprite.m_245424_().m_245330_(), displayWidth, displayHeight, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public static void repeatBlit(GuiGraphics graphics, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(graphics, sprite.m_247685_(), x, y, texWidth, texHeight, displayWidth, displayHeight, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public static void repeatBlit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, float minU, float maxU, float minV, float maxV) {
        int pixelsNowX;
        for (int pixelsRenderedX = 0; pixelsRenderedX < displayWidth; pixelsRenderedX += pixelsNowX) {
            int pixelsNowY;
            pixelsNowX = Math.min(texWidth, displayWidth - pixelsRenderedX);
            float maxUThisTime = maxU;
            if (pixelsNowX < texWidth) {
                maxUThisTime = minU + (maxU - minU) * ((float)pixelsNowX / (float)texWidth);
            }
            for (int pixelsRenderedY = 0; pixelsRenderedY < displayHeight; pixelsRenderedY += pixelsNowY) {
                pixelsNowY = Math.min(texHeight, displayHeight - pixelsRenderedY);
                float maxVThisTime = maxV;
                if (pixelsNowY < texHeight) {
                    maxVThisTime = minV + (maxV - minV) * ((float)pixelsNowY / (float)texHeight);
                }
                graphics.m_280444_(texture, x + pixelsRenderedX, x + pixelsRenderedX + pixelsNowX, y + pixelsRenderedY, y + pixelsRenderedY + pixelsNowY, 0, minU, maxUThisTime, minV, maxVThisTime);
            }
        }
    }

    public static void renderIconColored(PoseStack poseStack, VertexConsumer buffer, float x, float y, TextureAtlasSprite sprite, float width, float height, float alpha, int color, int light, int overlay) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(pose, x, y + height, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(pose, x + width, y + height, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(pose, x + width, y, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(pose, x, y, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void rgb(int color) {
        RenderSystem.setShaderColor((float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
    }

    public static void argb(int color) {
        RenderSystem.setShaderColor((float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24 & 0xFF) / 255.0f));
    }

    public static void resetColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderGuiBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderHelper.renderGuiBackground(graphics, x, y, width, height, TEXTURE_CHEST_GUI);
    }

    public static void renderGuiBackground(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation texture) {
        RenderHelper.renderGuiBackground(graphics, x, y, width, height, texture, 176, 222, 7, 169, 125, 139);
    }

    public static void renderGuiBackground(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation texture, int textureX, int textureY, int minU, int maxU, int minV, int maxV) {
        RenderHelper.repeatBlit(graphics, texture, x + 2, y + 2, maxU - minU, maxV - minV, width - 4, height - 4, (float)minU / 256.0f, (float)maxU / 256.0f, (float)minV / 256.0f, (float)maxV / 256.0f);
        graphics.m_280398_(texture, x, y, 0, 0.0f, 0.0f, 4, 4, 256, 256);
        graphics.m_280398_(texture, x + width - 5, y, 0, (float)(textureX - 4), 0.0f, 4, 4, 256, 256);
        graphics.m_280398_(texture, x, y + height - 5, 0, 0.0f, (float)(textureY - 4), 4, 4, 256, 256);
        graphics.m_280398_(texture, x + width - 5, y + height - 5, 0, (float)(textureX - 4), (float)(textureY - 4), 4, 4, 256, 256);
        RenderHelper.repeatBlit(graphics, texture, x + 4, y, 169, 3, width - 8, 3, 0.015625f, (float)(textureX - 3) / 256.0f, 0.0f, 0.01171875f);
        RenderHelper.repeatBlit(graphics, texture, x + 4, y + height - 4, 169, 3, width - 8, 3, 0.015625f, (float)(textureX - 3) / 256.0f, (float)(textureY - 3) / 256.0f, (float)textureY / 256.0f);
        RenderHelper.repeatBlit(graphics, texture, x, y + 4, 3, 214, 3, height - 8, 0.0f, 0.01171875f, 0.015625f, (float)(textureY - 4) / 256.0f);
        RenderHelper.repeatBlit(graphics, texture, x + width - 4, y + 4, 3, 214, 3, height - 8, (float)(textureX - 3) / 256.0f, (float)textureX / 256.0f, 0.015625f, (float)(textureY - 4) / 256.0f);
    }
}

