/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import org.moddingx.libx.util.lazy.LazyValue;
import sun.misc.Unsafe;

public class ReflectionHacks {
    private static final LazyValue<Unsafe> unsafe = new LazyValue<Unsafe>(() -> {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("ReflectionHacks: Couldn't get the Unsafe.", e);
        }
    });

    public static void throwUnchecked(Throwable t) {
        unsafe.get().throwException(t);
    }

    public static <T> T newInstance(Class<T> cls) throws InstantiationException {
        return (T)unsafe.get().allocateInstance(cls);
    }

    public static void setFinalField(Field field, Object instance, @Nullable Object value) {
        long offset;
        Object base;
        if (Modifier.isStatic(field.getModifiers())) {
            base = unsafe.get().staticFieldBase(field);
            offset = unsafe.get().staticFieldOffset(field);
        } else {
            if (instance == null) {
                throw new NullPointerException("No instance for non-static field: " + field);
            }
            if (!field.getDeclaringClass().isAssignableFrom(instance.getClass())) {
                throw new IllegalArgumentException("Instance has wrong type for field: " + instance + " " + field);
            }
            base = instance;
            offset = unsafe.get().objectFieldOffset(field);
        }
        if (field.getType() == Void.TYPE) {
            throw new IllegalStateException("Field with void type");
        }
        if (field.isEnumConstant()) {
            throw new IllegalArgumentException("Can't change enum constant");
        }
        if (field.getType() == Boolean.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putBooleanVolatile(base, offset, (Boolean)value);
        } else if (field.getType() == Byte.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putByteVolatile(base, offset, (Byte)value);
        } else if (field.getType() == Character.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putCharVolatile(base, offset, ((Character)value).charValue());
        } else if (field.getType() == Short.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putShortVolatile(base, offset, (Short)value);
        } else if (field.getType() == Integer.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putIntVolatile(base, offset, (Integer)value);
        } else if (field.getType() == Long.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putLongVolatile(base, offset, (Long)value);
        } else if (field.getType() == Float.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putFloatVolatile(base, offset, ((Float)value).floatValue());
        } else if (field.getType() == Double.TYPE) {
            if (value == null) {
                throw new NullPointerException("Null primitive for field: " + field);
            }
            unsafe.get().putDoubleVolatile(base, offset, (Double)value);
        } else {
            if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
                throw new ClassCastException("Expected value of type " + field.getType() + " for field " + field + ", got " + value.getClass());
            }
            unsafe.get().putObjectVolatile(base, offset, value);
        }
    }
}

