/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.registries;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datapack.DatapackHelper;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistrySet;
import org.moddingx.libx.util.lazy.LazyValue;

public class DatagenRegistry<T>
extends MappedRegistry<T> {
    private final DatagenRegistrySet registrySet;
    private final Codec<T> codec;
    private final Lookup lookup;
    private boolean frozen;
    private boolean propagateNewElementsToChildren;

    public static <T> DatagenRegistry<T> createRoot(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, Registry<T> rootRegistry) {
        return new DatagenRegistry<T>(registryKey, registrySet, codec, List.of(rootRegistry));
    }

    public static <T> DatagenRegistry<T> create(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, List<DatagenRegistry<T>> parents) {
        return new DatagenRegistry<T>(registryKey, registrySet, codec, parents.stream().map(dr -> dr).toList());
    }

    private DatagenRegistry(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, List<Registry<T>> fillFrom) {
        super(registryKey, Lifecycle.stable(), true);
        this.registrySet = registrySet;
        this.codec = codec;
        this.lookup = new Lookup();
        this.frozen = false;
        this.propagateNewElementsToChildren = true;
        HashMap parentElements = new HashMap();
        for (Registry<T> registry : fillFrom) {
            for (Map.Entry entry : registry.m_6579_()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                if (parentElements.containsKey(key) && value != parentElements.get(key)) {
                    throw new IllegalStateException("Can't create registry set: Inherited two different values for key " + key + ": " + parentElements.get(key) + " and " + value);
                }
                parentElements.put(key, value);
            }
        }
        for (Map.Entry entry : parentElements.entrySet()) {
            this.m_255290_((ResourceKey)entry.getKey(), entry.getValue(), Lifecycle.stable());
        }
    }

    @Nonnull
    public HolderOwner<T> m_255331_() {
        return this.lookup;
    }

    @Nonnull
    public HolderLookup.RegistryLookup<T> m_255303_() {
        return this.lookup;
    }

    @Nonnull
    public Holder.Reference<T> m_203704_(int id, @Nonnull ResourceKey<T> key, @Nonnull T value, @Nonnull Lifecycle lifecycle) {
        if (this.f_244282_ != null && !this.f_244282_.containsKey(value)) {
            this.m_203693_(value);
        }
        Holder.Reference holder = super.m_203704_(id, key, value, Lifecycle.stable());
        if (this.propagateNewElementsToChildren) {
            Set activeChildren = this.registrySet.collectActiveChildRegistries(this.m_123023_());
            for (DatagenRegistry child : activeChildren) {
                if (!child.m_142003_(key)) continue;
                throw new IllegalStateException("Can't add element to datagen registry: Already registered in child registry");
            }
            for (DatagenRegistry child : activeChildren) {
                child.registerOnlyThisRegistry(key, value, lifecycle);
            }
        }
        this.registrySet.trackHolderTarget(holder, this.m_123023_());
        return holder;
    }

    @Nonnull
    public Holder.Reference<T> m_203693_(@Nonnull T value) {
        Holder.Reference holder = this.m_7854_(value).flatMap(arg_0 -> ((DatagenRegistry)this).m_203636_(arg_0)).orElse(null);
        if (holder == null) {
            holder = super.m_203693_(value);
        }
        this.registrySet.trackHolderTarget(holder, this.m_123023_());
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder.Reference<T> registerOnlyThisRegistry(ResourceKey<T> key, T value, Lifecycle lifecycle) {
        try {
            this.propagateNewElementsToChildren = false;
            Holder.Reference reference = this.m_255290_(key, value, lifecycle);
            return reference;
        }
        finally {
            this.propagateNewElementsToChildren = true;
        }
    }

    @Nonnull
    public Registry<T> m_203521_() {
        for (DatagenRegistrySet parent : this.registrySet.getDirectParents()) {
            if (!parent.getDatagenRegistry(this.m_123023_(), false).stream().anyMatch(reg -> !reg.frozen)) continue;
            throw new IllegalStateException("Can't freeze datagen registry while its parents are still unfrozen.");
        }
        Registry result = super.m_203521_();
        this.frozen = true;
        return result;
    }

    public void unfreeze() {
        throw new UnsupportedOperationException();
    }

    public void writeOwnElements(PackTarget target, CachedOutput output) {
        if (!this.frozen) {
            throw new IllegalStateException("Can't serialize unfrozen registry: " + this.m_123023_());
        }
        LazyValue<Path> outputPath = new LazyValue<Path>(() -> target.path(PackType.SERVER_DATA));
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registrySet.registryAccess());
        List parents = this.registrySet.getDirectParents().stream().flatMap(parent -> parent.getDatagenRegistry(this.m_123023_(), false).stream()).toList();
        for (Map.Entry entry : this.m_6579_()) {
            if (!parents.stream().noneMatch(reg -> reg.m_142003_((ResourceKey)entry.getKey()))) continue;
            try {
                JsonElement json = (JsonElement)this.codec.encodeStart((DynamicOps)ops, entry.getValue()).getOrThrow(false, msg -> {});
                DataProvider.m_253162_((CachedOutput)output, (JsonElement)json, (Path)outputPath.get().resolve(DatapackHelper.registryPath((ResourceKey)entry.getKey())));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialise element " + entry.getKey() + " in datagen registry", e);
            }
        }
    }

    private class Lookup
    implements HolderLookup.RegistryLookup<T> {
        private Lookup() {
        }

        @Nonnull
        public ResourceKey<? extends Registry<? extends T>> m_254879_() {
            return DatagenRegistry.this.m_123023_();
        }

        @Nonnull
        public Lifecycle m_254883_() {
            return DatagenRegistry.this.m_203658_();
        }

        @Nonnull
        public Stream<Holder.Reference<T>> m_214062_() {
            return DatagenRegistry.this.m_203611_();
        }

        @Nonnull
        public Stream<HolderSet.Named<T>> m_214063_() {
            return DatagenRegistry.this.m_203612_().map(Pair::getSecond);
        }

        @Nonnull
        public Optional<Holder.Reference<T>> m_254902_(@Nonnull ResourceKey<T> key) {
            return DatagenRegistry.this.m_203636_(key);
        }

        @Nonnull
        public Optional<HolderSet.Named<T>> m_254901_(@Nonnull TagKey<T> key) {
            return DatagenRegistry.this.m_203431_(key);
        }

        public boolean m_254921_(@Nonnull HolderOwner<T> owner) {
            return true;
        }
    }
}

