/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.tags;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.datagen.tags.DecorationTags;
import org.moddingx.libx.impl.tags.InternalTagProvider;
import org.moddingx.libx.impl.tags.InternalTags;
import org.moddingx.libx.mod.ModX;

public abstract class CommonTagsProviderBase
implements DataProvider {
    protected final ModX mod;
    private final BlockTagProviderBase blockTags;
    private final ItemTagProviderBase itemTags;
    private final FluidTagProviderBase fluidTags;
    private boolean isSetup = false;
    private final List<Runnable> itemCopies = new ArrayList<Runnable>();
    private final List<Pair<TagKey<Fluid>, TagKey<Block>>> fluidCopies = new ArrayList<Pair<TagKey<Fluid>, TagKey<Block>>>();
    private boolean hasLibXInternalTags = false;

    public CommonTagsProviderBase(DatagenContext ctx) {
        this.mod = ctx.mod();
        CompletableFuture<RegistryAccess> lookupProvider = CompletableFuture.completedFuture(ctx.registries().registryAccess());
        this.blockTags = new BlockTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper());
        this.itemTags = new ItemTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper(), this.blockTags);
        this.fluidTags = new FluidTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper());
        ctx.addAdditionalProvider(c -> this.blockTags);
        ctx.addAdditionalProvider(c -> this.itemTags);
        ctx.addAdditionalProvider(c -> this.fluidTags);
    }

    public abstract void setup();

    private void doSetup() {
        if (this.getClass() == InternalTagProvider.class) {
            this.initInternalTags();
        }
        this.setup();
        ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(Map.Entry::getValue).forEach(block -> {
            DecorationTags.addTags(block, this, this::initInternalTags);
            this.defaultBlockTags((Block)block);
        });
        ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(Map.Entry::getValue).forEach(this::defaultItemTags);
        ForgeRegistries.FLUIDS.getEntries().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(Map.Entry::getValue).forEach(this::defaultFluidTags);
    }

    public void defaultItemTags(Item item) {
    }

    public void defaultBlockTags(Block block) {
    }

    public void defaultFluidTags(Fluid fluid) {
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> item(TagKey<Item> tag) {
        return this.itemTags.m_206424_(tag);
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> block(TagKey<Block> tag) {
        return this.blockTags.m_206424_(tag);
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> fluid(TagKey<Fluid> tag) {
        return this.fluidTags.m_206424_(tag);
    }

    public void copyBlock(TagKey<Block> from, TagKey<Item> to) {
        this.itemCopies.add(() -> this.itemTags.m_206421_(from, to));
    }

    public void copyFluid(TagKey<Fluid> from, TagKey<Block> to) {
        this.fluidCopies.add((Pair<TagKey<Fluid>, TagKey<Block>>)Pair.of(from, to));
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " common tags";
    }

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        return CompletableFuture.completedFuture(null);
    }

    private void initInternalTags() {
        if (!this.hasLibXInternalTags) {
            this.hasLibXInternalTags = true;
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getTags().entrySet()) {
                this.item(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Blocks.getTags().entrySet()) {
                this.block(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getCopies().entrySet()) {
                this.copyBlock(entry.getKey(), entry.getValue());
            }
        }
    }

    private class BlockTagProviderBase
    extends BlockTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected BlockTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper) {
            super(packOutput, lookupProvider, modid, fileHelper);
        }

        protected void m_6577_(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
            for (Pair<TagKey<Fluid>, TagKey<Block>> copy : CommonTagsProviderBase.this.fluidCopies) {
                IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> builder = this.m_206424_((TagKey<Block>)((TagKey)copy.getRight()));
                for (ResourceLocation entry : CommonTagsProviderBase.this.fluidTags.getTagInfo((TagKey<Fluid>)((TagKey)copy.getLeft()))) {
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(entry);
                    if (fluid == null) continue;
                    builder.m_255245_((Object)fluid.m_76145_().m_76188_().m_60734_());
                }
            }
        }

        @Nonnull
        public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.f_126543_);
            return super.m_213708_(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> m_206424_(@Nonnull TagKey<Block> tag) {
            return super.m_206424_(tag);
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common block tags";
        }
    }

    private class ItemTagProviderBase
    extends ItemTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected ItemTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper, BlockTagProviderBase blockTags) {
            super(packOutput, lookupProvider, blockTags.m_274426_(), modid, fileHelper);
        }

        protected void m_6577_(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
            for (Runnable copy : CommonTagsProviderBase.this.itemCopies) {
                copy.run();
            }
        }

        @Nonnull
        public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.f_126543_);
            return super.m_213708_(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> m_206424_(@Nonnull TagKey<Item> tag) {
            return super.m_206424_(tag);
        }

        public void m_206421_(@Nonnull TagKey<Block> blockTag, @Nonnull TagKey<Item> itemTag) {
            super.m_206421_(blockTag, itemTag);
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common item tags";
        }
    }

    private class FluidTagProviderBase
    extends FluidTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected FluidTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper) {
            super(packOutput, lookupProvider, modid, fileHelper);
        }

        protected void m_6577_(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
        }

        @Nonnull
        public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.f_126543_);
            return super.m_213708_(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> m_206424_(@Nonnull TagKey<Fluid> tag) {
            return super.m_206424_(tag);
        }

        public List<ResourceLocation> getTagInfo(TagKey<Fluid> tag) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> builder = this.m_206424_(tag);
            return builder.getInternalBuilder().f_215897_.stream().filter(p -> !p.f_215914_).map(TagEntry::getId).toList();
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common fluid tags";
        }
    }
}

