/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component;

import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nullable;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Template;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.Component;

public class TextComponent
extends Component<TextComponent> {
    private final String text;
    @Nullable
    private String color;
    protected Optional<Integer> maxWidth = Optional.empty();
    protected Optional<Integer> maxHeight = Optional.empty();

    public TextComponent(Template.Properties parent, String text) {
        super(parent, "patchouli:text");
        this.text = text;
    }

    public TextComponent setColor(@Nullable String color) {
        this.color = color;
        return this;
    }

    public TextComponent setMaxWidth(int maxWidth) {
        this.maxWidth = Optional.of(maxWidth);
        return this;
    }

    public TextComponent setMaxHeight(int maxHeight) {
        this.maxHeight = Optional.of(maxHeight);
        return this;
    }

    @Override
    protected void serializeData(JsonObject jsonobject) {
        if (this.color != null) {
            jsonobject.addProperty("color", this.color);
        }
        this.maxWidth.ifPresent(integer -> jsonobject.addProperty("max_width", (Number)integer));
        this.maxHeight.ifPresent(integer -> jsonobject.addProperty("max_height", (Number)integer));
    }
}

