/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component;

import com.google.gson.JsonObject;
import java.util.Optional;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Template;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.Component;

public class ImageComponent
extends Component<ImageComponent> {
    private final String image;
    private final int width;
    private final int height;
    private Optional<Integer> u = Optional.empty();
    private Optional<Integer> v = Optional.empty();
    private Optional<Integer> textureWidth = Optional.empty();
    private Optional<Integer> textureHeight = Optional.empty();
    private Optional<Float> scale = Optional.empty();

    public ImageComponent(Template.Properties parent, String image, int width, int height) {
        super(parent, "patchouli:image");
        this.image = image;
        this.width = width;
        this.height = height;
    }

    public ImageComponent setU(int u) {
        this.u = Optional.of(u);
        return this;
    }

    public ImageComponent setV(int v) {
        this.v = Optional.of(v);
        return this;
    }

    public ImageComponent setTextureWidth(int textureWidth) {
        this.textureWidth = Optional.of(textureWidth);
        return this;
    }

    public ImageComponent setTextureHeight(int textureHeight) {
        this.textureHeight = Optional.of(textureHeight);
        return this;
    }

    public ImageComponent setScale(float scale) {
        this.scale = Optional.of(Float.valueOf(scale));
        return this;
    }

    @Override
    protected void serializeData(JsonObject jsonobject) {
        jsonobject.addProperty("image", this.image);
        jsonobject.addProperty("width", (Number)this.width);
        jsonobject.addProperty("height", (Number)this.height);
        this.u.ifPresent(integer -> jsonobject.addProperty("u", (Number)integer));
        this.v.ifPresent(integer -> jsonobject.addProperty("v", (Number)integer));
        this.textureWidth.ifPresent(integer -> jsonobject.addProperty("texture_width", (Number)integer));
        this.textureHeight.ifPresent(integer -> jsonobject.addProperty("texture_height", (Number)integer));
        this.scale.ifPresent(aFloat -> jsonobject.addProperty("scale", (Number)aFloat));
    }
}

