/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.Function;
import jp.artan.artansprojectcoremod.forge.providers.RegistratePatchouliProvider;
import jp.artan.artansprojectcoremod.forge.providers.builder.PatchouliBuilder;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.Entry;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.Page;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Templates;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.Component;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.CustomComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.EntityComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.FrameComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.HeaderComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.ImageComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.ItemComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.SeparatorComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.TextComponent;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.component.TooltipComponent;
import jp.artan.artansprojectcoremod.utils.inject.NonNullBiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;

public class Template<T extends Page<T>>
implements RegistratePatchouliProvider.Result {
    private final ResourceLocation id;
    private final PatchouliBuilder parent;
    private final Templates templates;
    private final String name;
    private final Properties properties;
    private final NonNullBiFunction<String, Entry.Properties, T> pageFactory;

    public Template(PatchouliBuilder parent, Templates templates, String name, NonNullBiFunction<String, Entry.Properties, T> pageFactory) {
        this.id = new ResourceLocation(parent.modId, name);
        this.parent = parent;
        this.templates = templates;
        this.name = name;
        this.properties = new Properties();
        this.pageFactory = pageFactory;
    }

    public Template<T> properties(Function<Properties, Properties> properties) {
        properties.apply(this.properties);
        return this;
    }

    public T createPage(Entry.Properties properties) {
        return (T)((Page)this.pageFactory.apply(this.name, properties));
    }

    public Templates build() {
        return this.templates;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        JsonArray components = new JsonArray();
        for (Component component : this.properties.components) {
            components.add((JsonElement)component.serialize());
        }
        jsonObject.add("components", (JsonElement)components);
        return jsonObject;
    }

    @Override
    public Path getPath(Path pathIn) {
        return PatchouliBuilder.getBasePath(this.parent.getId(), pathIn, "/en_us/templates/" + this.getTemplateId() + ".json");
    }

    @Override
    public RegistratePatchouliProvider.ProviderType getProviderType() {
        return RegistratePatchouliProvider.ProviderType.BOOK_TEMPLATE;
    }

    public String getTemplateId() {
        return this.name;
    }

    public static class Properties {
        private final NonNullList<Component<?>> components = NonNullList.m_122779_();

        public TextComponent addTextComponent(String text) {
            TextComponent component = new TextComponent(this, text);
            this.components.add((Object)component);
            return component;
        }

        public ItemComponent addItemComponent(String item) {
            ItemComponent component = new ItemComponent(this, item);
            this.components.add((Object)component);
            return component;
        }

        public ImageComponent addImageComponent(String image, int width, int height) {
            ImageComponent component = new ImageComponent(this, image, width, height);
            this.components.add((Object)component);
            return component;
        }

        public HeaderComponent addHeaderComponent(String text) {
            HeaderComponent component = new HeaderComponent(this, text);
            this.components.add((Object)component);
            return component;
        }

        public EntityComponent addEntityComponent(String entity) {
            EntityComponent component = new EntityComponent(this, entity);
            this.components.add((Object)component);
            return component;
        }

        public SeparatorComponent addSeparatorComponent() {
            SeparatorComponent component = new SeparatorComponent(this);
            this.components.add((Object)component);
            return component;
        }

        public FrameComponent addFrameComponent() {
            FrameComponent component = new FrameComponent(this);
            this.components.add((Object)component);
            return component;
        }

        public TooltipComponent addTooltipComponent() {
            TooltipComponent component = new TooltipComponent(this);
            this.components.add((Object)component);
            return component;
        }

        public CustomComponent addCustomComponent(String className) {
            CustomComponent component = new CustomComponent(this, className);
            this.components.add((Object)component);
            return component;
        }
    }
}

