/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.Entry;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.Page;
import net.minecraft.core.NonNullList;

public class MultiblockPage
extends Page<MultiblockPage> {
    private final String name;
    private Optional<String> multiblockId = Optional.empty();
    private MultiblockProperties multiblock;
    private Optional<Boolean> enableVisualize = Optional.empty();
    private Optional<String> text = Optional.empty();

    public MultiblockPage(Entry.Properties parent, String name) {
        super(parent, "patchouli:multiblock");
        this.name = name;
        this.multiblock = new MultiblockProperties(this);
    }

    public MultiblockPage setMultiblockId(String multiblockId) {
        this.multiblockId = Optional.of(multiblockId);
        return this;
    }

    public MultiblockPage setEnableVisualize(boolean enableVisualize) {
        this.enableVisualize = Optional.of(enableVisualize);
        return this;
    }

    public MultiblockPage setText(String text) {
        this.text = Optional.of(text);
        return this;
    }

    @Override
    protected void serializeData(JsonObject jsonobject) {
        jsonobject.addProperty("name", this.name);
        this.multiblockId.ifPresent(multiblockId -> jsonobject.addProperty("multiblock", multiblockId));
        this.enableVisualize.ifPresent(enableVisualize -> jsonobject.addProperty("enable_visualize", enableVisualize));
        this.text.ifPresent(text -> jsonobject.addProperty("text", text));
        JsonObject multiblockJson = new JsonObject();
        JsonObject mappingJson = new JsonObject();
        for (Map.Entry<String, String> entry : this.multiblock.properties.entrySet()) {
            mappingJson.addProperty(entry.getKey(), entry.getValue());
        }
        multiblockJson.add("mapping", (JsonElement)mappingJson);
        JsonArray patternJson = new JsonArray();
        for (String[] pattern : this.multiblock.pattern) {
            JsonArray patternRowJson = new JsonArray();
            for (String patternRow : pattern) {
                patternRowJson.add(patternRow);
            }
            patternJson.add((JsonElement)patternRowJson);
        }
        multiblockJson.add("pattern", (JsonElement)patternJson);
        this.multiblock.symmetrical.ifPresent(symmetrical -> multiblockJson.addProperty("symmetrical", symmetrical));
        this.multiblock.offset.ifPresent(offset -> {
            JsonArray offsetJson = new JsonArray();
            for (int offsetValue : offset) {
                offsetJson.add((Number)offsetValue);
            }
            multiblockJson.add("offset", (JsonElement)offsetJson);
        });
        jsonobject.add("multiblock", (JsonElement)multiblockJson);
    }

    public static class MultiblockProperties {
        private final MultiblockPage parent;
        private final HashMap<String, String> properties = new HashMap();
        private final NonNullList<String[]> pattern = NonNullList.m_122779_();
        private Optional<Boolean> symmetrical = Optional.empty();
        private Optional<int[]> offset = Optional.empty();

        public MultiblockProperties(MultiblockPage parent) {
            this.parent = parent;
        }

        public MultiblockProperties addMapping(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public MultiblockProperties addPattern(String ... pattern) {
            this.pattern.add((Object)pattern);
            return this;
        }

        public MultiblockProperties setSymmetrical(boolean symmetrical) {
            this.symmetrical = Optional.of(symmetrical);
            return this;
        }

        public MultiblockProperties setOffset(int x, int y, int z) {
            this.offset = Optional.of(new int[]{x, y, z});
            return this;
        }

        public MultiblockPage build() {
            return this.parent;
        }
    }
}

