/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages;

import com.google.gson.JsonObject;
import java.util.Optional;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.Entry;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.Page;

public class EntityPage
extends Page<EntityPage> {
    private final String entity;
    private Optional<Float> scale = Optional.empty();
    private Optional<Float> offset = Optional.empty();
    private Optional<Boolean> rotate = Optional.empty();
    private Optional<Float> defaultRotation = Optional.empty();
    private Optional<String> name = Optional.empty();
    private Optional<String> text = Optional.empty();

    public EntityPage(Entry.Properties parent, String entity) {
        super(parent, "patchouli:entity");
        this.entity = entity;
    }

    public EntityPage setScale(float scale) {
        this.scale = Optional.of(Float.valueOf(scale));
        return this;
    }

    public EntityPage setOffset(float offset) {
        this.offset = Optional.of(Float.valueOf(offset));
        return this;
    }

    public EntityPage setNoRotate() {
        this.rotate = Optional.of(false);
        return this;
    }

    public EntityPage setDefaultRotation(float defaultRotation) {
        this.defaultRotation = Optional.of(Float.valueOf(defaultRotation));
        return this;
    }

    public EntityPage setName(String name) {
        this.name = Optional.of(name);
        return this;
    }

    public EntityPage setText(String text) {
        this.text = Optional.of(text);
        return this;
    }

    @Override
    protected void serializeData(JsonObject jsonobject) {
        jsonobject.addProperty("entity", this.entity);
        this.scale.ifPresent(aFloat -> jsonobject.addProperty("scale", (Number)aFloat));
        this.offset.ifPresent(aFloat -> jsonobject.addProperty("offset", (Number)aFloat));
        this.rotate.ifPresent(aBoolean -> jsonobject.addProperty("rotate", aBoolean));
        this.defaultRotation.ifPresent(aFloat -> jsonobject.addProperty("default_rotation", (Number)aFloat));
        this.name.ifPresent(name -> jsonobject.addProperty("name", name));
        this.text.ifPresent(text -> jsonobject.addProperty("text", text));
    }
}

