/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.RegistrySupplier;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import jp.artan.artansprojectcoremod.forge.providers.RegistratePatchouliProvider;
import jp.artan.artansprojectcoremod.forge.providers.builder.PatchouliBuilder;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.Entries;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.CraftingRecipePage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.EmptyPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.EntityPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.ImagePage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.LinkPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.MultiblockPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.Page;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.QuestPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.RelationsPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.SmeltingRecipePage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.SpotlightPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.pages.TextPage;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Template;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Entry
implements RegistratePatchouliProvider.Result {
    private final PatchouliBuilder parent;
    private final Entries entries;
    private final Properties properties;

    protected Entry(PatchouliBuilder parent, Entries entries, int index, String fileName, String lang, String category, String icon) {
        this.parent = parent;
        this.entries = entries;
        this.properties = new Properties(fileName, lang, category, icon, index);
    }

    public Entry properties(Function<Properties, Properties> properties) {
        properties.apply(this.properties);
        return this;
    }

    public Entries build() {
        return this.entries;
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation(this.parent.modId, this.getEntryId());
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.properties.lang);
        jsonobject.addProperty("category", this.properties.category);
        jsonobject.addProperty("icon", this.properties.icon);
        this.properties.advancement.ifPresent(advancement -> jsonobject.addProperty("advancement", advancement.toString()));
        this.properties.flag.ifPresent(flag -> jsonobject.addProperty("flag", flag));
        this.properties.priority.ifPresent(priority -> jsonobject.addProperty("priority", priority));
        this.properties.secret.ifPresent(secret -> jsonobject.addProperty("secret", secret));
        this.properties.readByDefault.ifPresent(readByDefault -> jsonobject.addProperty("read_by_default", readByDefault));
        this.properties.sortnum.ifPresent(sortnum -> jsonobject.addProperty("sortnum", (Number)sortnum));
        this.properties.turnin.ifPresent(turnin -> jsonobject.addProperty("turnin", turnin));
        if (!this.properties.extraRecipeMappings.isEmpty()) {
            JsonObject extraRecipeMappingsJsonObject = new JsonObject();
            for (Map.Entry<String, Integer> extraRecipeMapping : this.properties.extraRecipeMappings.entrySet()) {
                extraRecipeMappingsJsonObject.addProperty(extraRecipeMapping.getKey(), (Number)extraRecipeMapping.getValue());
            }
            jsonobject.add("extra_recipe_mappings", (JsonElement)extraRecipeMappingsJsonObject);
        }
        JsonArray pagesJsonArray = new JsonArray();
        for (Page page : this.properties.pages) {
            pagesJsonArray.add((JsonElement)page.serialize());
        }
        jsonobject.add("pages", (JsonElement)pagesJsonArray);
        return jsonobject;
    }

    @Override
    public Path getPath(Path pathIn) {
        return PatchouliBuilder.getBasePath(this.parent.getId(), pathIn, "/en_us/entries/" + this.getEntryId() + ".json");
    }

    @Override
    public RegistratePatchouliProvider.ProviderType getProviderType() {
        return RegistratePatchouliProvider.ProviderType.BOOK_ENTRY;
    }

    private String getEntryId() {
        return this.getCategoryId() + "/" + this.properties.sortnum.get() + "_" + this.properties.fileName.replace(" ", "_").toLowerCase();
    }

    private String getCategoryId() {
        return this.entries.getCategoryId();
    }

    public static class Properties {
        private final String fileName;
        private final String lang;
        private final String category;
        private final String icon;
        private final NonNullList<Page<?>> pages = NonNullList.m_122779_();
        private Optional<String> advancement = Optional.empty();
        private Optional<String> flag = Optional.empty();
        private Optional<Boolean> priority = Optional.empty();
        private Optional<Boolean> secret = Optional.empty();
        private Optional<Boolean> readByDefault = Optional.empty();
        private Optional<Integer> sortnum;
        private Optional<String> turnin = Optional.empty();
        private HashMap<String, Integer> extraRecipeMappings = new HashMap();

        public Properties(String fileName, String lang, String category, String icon, int sortnum) {
            this.fileName = fileName;
            this.lang = lang;
            this.category = category;
            this.icon = icon;
            this.sortnum = Optional.of(sortnum);
        }

        public Properties getAdvancement(String advancement) {
            this.advancement = Optional.of(advancement);
            return this;
        }

        public Properties setFlag(String flag) {
            this.flag = Optional.of(flag);
            return this;
        }

        public Properties sePriority(boolean priority) {
            this.priority = Optional.of(priority);
            return this;
        }

        public Properties setSecret(boolean secret) {
            this.secret = Optional.of(secret);
            return this;
        }

        public Properties setReadByDefault(boolean readByDefault) {
            this.readByDefault = Optional.of(readByDefault);
            return this;
        }

        public Properties setSortnum(int sortnum) {
            this.sortnum = Optional.of(sortnum);
            return this;
        }

        public Properties setTurnin(String turnin) {
            this.turnin = Optional.of(turnin);
            return this;
        }

        public Properties addExtraRecipeMapping(ItemStack itemStack, int page) {
            this.extraRecipeMappings.put(itemStack.m_41778_(), page);
            return this;
        }

        public TextPage addTextPage(String text) {
            TextPage page = new TextPage(this, text);
            this.pages.add((Object)page);
            return page;
        }

        public ImagePage addImagePage(String image) {
            ImagePage page = new ImagePage(this, new String[]{image});
            this.pages.add((Object)page);
            return page;
        }

        public CraftingRecipePage addCraftingRecipePage(RegistrySupplier<? extends ItemLike> itemLike) {
            return this.addCraftingRecipePage(itemLike.getId());
        }

        public CraftingRecipePage addCraftingRecipePage(ResourceLocation recipe) {
            CraftingRecipePage page = new CraftingRecipePage(this, recipe);
            this.pages.add((Object)page);
            return page;
        }

        public SmeltingRecipePage addSmeltingRecipePage(ResourceLocation recipe) {
            SmeltingRecipePage page = new SmeltingRecipePage(this, recipe);
            this.pages.add((Object)page);
            return page;
        }

        public MultiblockPage addMultiblockPage(String name) {
            MultiblockPage page = new MultiblockPage(this, name);
            this.pages.add((Object)page);
            return page;
        }

        public EntityPage addEntityPage(String entity) {
            EntityPage page = new EntityPage(this, entity);
            this.pages.add((Object)page);
            return page;
        }

        public SpotlightPage addSpotlightPage(RegistrySupplier<? extends ItemLike> itemLike) {
            return this.addSpotlightPage(itemLike.getId().toString());
        }

        public SpotlightPage addSpotlightPage(String item) {
            SpotlightPage page = new SpotlightPage(this, item);
            this.pages.add((Object)page);
            return page;
        }

        public LinkPage addRelatedPage(String url, String linkText) {
            LinkPage page = new LinkPage(this, url, linkText);
            this.pages.add((Object)page);
            return page;
        }

        public RelationsPage addRelatedPage() {
            RelationsPage page = new RelationsPage(this);
            this.pages.add((Object)page);
            return page;
        }

        public QuestPage addQuestPage() {
            QuestPage page = new QuestPage(this);
            this.pages.add((Object)page);
            return page;
        }

        public EmptyPage addEmptyPage() {
            EmptyPage page = new EmptyPage(this);
            this.pages.add((Object)page);
            return page;
        }

        public <T extends Page<T>> T addCustomPage(String type, Template<T> template) {
            T page = template.createPage(this);
            this.pages.add(page);
            return page;
        }
    }
}

