/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers.builder;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.function.Consumer;
import jp.artan.artansprojectcoremod.forge.providers.RegistratePatchouliProvider;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.Book;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.Categories;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.Category;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.category.entry.Entry;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Template;
import jp.artan.artansprojectcoremod.forge.providers.builder.patchoulibuilder.template.Templates;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;

public class PatchouliBuilder {
    public final String modId;
    private final ExistingFileHelper existingFileHelper;
    private final ResourceLocation location;
    private final Book book;
    private final Categories categories;
    private final Templates templates;

    public PatchouliBuilder(String modId, String name, ExistingFileHelper existingFileHelper) {
        this.modId = modId;
        this.location = new ResourceLocation(modId, name);
        this.existingFileHelper = existingFileHelper;
        this.book = new Book(this.location, this);
        this.categories = new Categories(this);
        this.templates = new Templates(this);
    }

    public Book book() {
        return this.book;
    }

    public Categories categories() {
        return this.categories;
    }

    public Templates getTemplates() {
        return this.templates;
    }

    public void save(Consumer<RegistratePatchouliProvider.Result> consumer) {
        consumer.accept(this.book);
        if (this.book.getRecipe() != null) {
            consumer.accept(this.book.getRecipe());
        }
        for (Template template : this.templates.getTemplates()) {
            consumer.accept(template);
        }
        for (Category category : this.categories.getCategories()) {
            consumer.accept(category);
            for (Entry entry : category.getEntries()) {
                consumer.accept(entry);
            }
        }
    }

    public ResourceLocation getId() {
        return this.location;
    }

    public void existTextureFile(ResourceLocation location) {
        boolean fileExist = this.existingFileHelper.exists(location, PackType.CLIENT_RESOURCES);
        Preconditions.checkState((boolean)fileExist, (String)"Texture at %s does not exist", (Object)location);
    }

    public static Path getBasePath(ResourceLocation location, Path pathIn, String children) {
        return PatchouliBuilder.getBasePath(location, pathIn, children, true);
    }

    public static Path getBasePath(ResourceLocation location, Path pathIn, String children, boolean isAssets) {
        return pathIn.resolve((isAssets ? "assets/" : "data/") + location.m_135827_() + "/patchouli_books/" + location.m_135815_() + children);
    }
}

