/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import jp.artan.artansprojectcoremod.forge.providers.builder.PatchouliBuilder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public abstract class RegistratePatchouliProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private Set<ResourceLocation> seenPatchouli = new HashSet<ResourceLocation>();

    public RegistratePatchouliProvider(boolean pRun, String modid, DataGenerator pGenerator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = pGenerator;
        this.existingFileHelper = existingFileHelper;
        pGenerator.addProvider(pRun, (DataProvider)new ItemModelProvider(pGenerator.getPackOutput(), modid, existingFileHelper){

            public String m_6055_() {
                return "Patchouli Item Model Provider";
            }

            protected void registerModels() {
                f_252483_.debug("Registering Patchouli Item Models");
                RegistratePatchouliProvider.this.registerPatchouli(result -> {
                    if (result.getProviderType() == ProviderType.BOOK_ITEM) {
                        f_252483_.debug("Registering Patchouli Item Model: {}", (Object)result.getId().m_135815_());
                        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(result.getId().m_135815_())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", new ResourceLocation(this.modid, "item/" + result.getId().m_135815_()));
                    }
                });
            }
        });
    }

    public PatchouliBuilder book(String name) {
        return new PatchouliBuilder(this.modid, name, this.existingFileHelper);
    }

    public String m_6055_() {
        return "Patchouli";
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        LOGGER.debug("Registering Patchouli Books");
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.registerPatchouli(result -> {
            LOGGER.debug("Registering Patchouli Book: {}", (Object)result.getId().m_135815_());
            if (!set.add(result.getId())) {
                throw new IllegalStateException("Duplicate patchouli " + result.getId());
            }
            Path path = result.getPath(this.generator.getPackOutput().m_245114_());
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)result.serialize(), (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void registerPatchouli(Consumer<Result> var1);

    public static interface Result {
        public ResourceLocation getId();

        public JsonObject serialize();

        public Path getPath(Path var1);

        public ProviderType getProviderType();
    }

    public static enum ProviderType {
        BOOK_ITEM,
        BOOK_CATEGORY,
        BOOK_ENTRY,
        BOOK_RECIPE,
        BOOK_TEMPLATE;

    }
}

